/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.spring;

import com.yammer.metrics.annotation.Gauge;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.spring.AnnotationMethodFilter;
import com.yammer.metrics.spring.GaugeMethod;
import java.lang.reflect.Method;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

public class GaugeAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    private static final ReflectionUtils.MethodFilter filter = new AnnotationMethodFilter(Gauge.class);
    private final MetricsRegistry metrics;

    public GaugeAnnotationBeanPostProcessor(MetricsRegistry metrics) {
        this.metrics = metrics;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithMethods((Class)AopUtils.getTargetClass((Object)bean), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                if (method.getParameterTypes().length != 0) {
                    throw new IllegalStateException("Method " + method.getName() + " is annotated with @Gauge but requires parameters.");
                }
                Gauge gauge = method.getAnnotation(Gauge.class);
                String name = gauge.name().isEmpty() ? method.getName() : gauge.name();
                GaugeAnnotationBeanPostProcessor.this.metrics.newGauge(method.getDeclaringClass(), name, (com.yammer.metrics.core.Gauge)new GaugeMethod(bean, method));
            }
        }, (ReflectionUtils.MethodFilter)filter);
        return bean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

