/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.spring;

import com.yammer.metrics.annotation.ExceptionMetered;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.spring.AnnotationMethodFilter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

public class ExceptionMeteredMethodInterceptor
implements MethodInterceptor,
ReflectionUtils.MethodCallback,
Ordered {
    private static final ReflectionUtils.MethodFilter filter = new AnnotationMethodFilter(ExceptionMetered.class);
    private final MetricsRegistry metrics;
    private final Class<?> targetClass;
    private final Map<String, Meter> meters;
    private final Map<String, Class<? extends Throwable>> causes;

    public ExceptionMeteredMethodInterceptor(MetricsRegistry metrics, Class<?> targetClass) {
        this.metrics = metrics;
        this.targetClass = targetClass;
        this.meters = new HashMap<String, Meter>();
        this.causes = new HashMap<String, Class<? extends Throwable>>();
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)this, (ReflectionUtils.MethodFilter)filter);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return invocation.proceed();
        }
        catch (Throwable t) {
            String name = invocation.getMethod().getName();
            if (this.causes.get(name).isAssignableFrom(t.getClass())) {
                this.meters.get(name).mark();
            }
            ReflectionUtils.rethrowException((Throwable)t);
            return null;
        }
    }

    public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
        ExceptionMetered metered = method.getAnnotation(ExceptionMetered.class);
        String methodName = method.getName();
        String meterName = metered.name().isEmpty() ? methodName + "Exceptions" : metered.name();
        Meter meter = this.metrics.newMeter(this.targetClass, meterName, metered.eventType(), metered.rateUnit());
        this.meters.put(methodName, meter);
        this.causes.put(methodName, metered.cause());
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

