/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.spring.config;

import com.yammer.metrics.core.HealthCheckRegistry;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.spring.ExceptionMeteredAnnotationBeanPostProcessor;
import com.yammer.metrics.spring.GaugeAnnotationBeanPostProcessor;
import com.yammer.metrics.spring.HealthCheckBeanPostProcessor;
import com.yammer.metrics.spring.MeteredAnnotationBeanPostProcessor;
import com.yammer.metrics.spring.TimedAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AnnotationDrivenBeanDefinitionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String healthCheckBeanName;
        Object source = parserContext.extractSource((Object)element);
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), source);
        parserContext.pushContainingComponent(compDefinition);
        String metricsBeanName = element.getAttribute("metrics-registry");
        if (!StringUtils.hasText((String)metricsBeanName)) {
            metricsBeanName = this.registerComponent(parserContext, source, 0, MetricsRegistry.class, null);
        }
        if (!StringUtils.hasText((String)(healthCheckBeanName = element.getAttribute("health-check-registry")))) {
            healthCheckBeanName = this.registerComponent(parserContext, source, 0, HealthCheckRegistry.class, null);
        }
        this.registerComponent(parserContext, source, 2, ExceptionMeteredAnnotationBeanPostProcessor.class, metricsBeanName);
        this.registerComponent(parserContext, source, 2, MeteredAnnotationBeanPostProcessor.class, metricsBeanName);
        this.registerComponent(parserContext, source, 2, TimedAnnotationBeanPostProcessor.class, metricsBeanName);
        this.registerComponent(parserContext, source, 2, GaugeAnnotationBeanPostProcessor.class, metricsBeanName);
        this.registerComponent(parserContext, source, 2, HealthCheckBeanPostProcessor.class, healthCheckBeanName);
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private String registerComponent(ParserContext parserContext, Object source, int role, Class<?> klazz, String argBeanName) {
        BeanDefinitionBuilder beanDefBuilder = BeanDefinitionBuilder.rootBeanDefinition(klazz);
        beanDefBuilder.setRole(role);
        beanDefBuilder.getRawBeanDefinition().setSource(source);
        if (argBeanName != null) {
            beanDefBuilder.addConstructorArgReference(argBeanName);
        }
        return this.registerComponent(parserContext, (BeanDefinition)beanDefBuilder.getBeanDefinition());
    }

    private String registerComponent(ParserContext parserContext, BeanDefinition beanDef) {
        String beanName = parserContext.getReaderContext().registerWithGeneratedName(beanDef);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(beanDef, beanName));
        return beanName;
    }
}

