/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.spring;

import com.yammer.metrics.annotation.Metered;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.spring.AnnotationMethodFilter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.ReflectionUtils;

public class MeteredMethodInterceptor
implements MethodInterceptor,
ReflectionUtils.MethodCallback {
    private static final ReflectionUtils.MethodFilter filter = new AnnotationMethodFilter(Metered.class);
    protected final MetricsRegistry metrics;
    protected final Class<?> targetClass;
    protected final Map<String, Meter> meters;

    public MeteredMethodInterceptor(MetricsRegistry metrics, Class<?> targetClass) {
        this.metrics = metrics;
        this.targetClass = targetClass;
        this.meters = new HashMap<String, Meter>();
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)this, (ReflectionUtils.MethodFilter)filter);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        this.meters.get(invocation.getMethod().getName()).mark();
        return invocation.proceed();
    }

    public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
        Metered metered = method.getAnnotation(Metered.class);
        String methodName = method.getName();
        String meterName = metered.name().isEmpty() ? methodName : metered.name();
        Meter meter = this.metrics.newMeter(this.targetClass, meterName, metered.eventType(), metered.rateUnit());
        this.meters.put(methodName, meter);
    }
}

