/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.httpclient;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultRequestDirector;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;

class InstrumentedRequestDirector
extends DefaultRequestDirector {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String HEAD = "HEAD";
    private static final String PUT = "PUT";
    private static final String OPTIONS = "OPTIONS";
    private static final String DELETE = "DELETE";
    private static final String TRACE = "TRACE";
    private static final String CONNECT = "CONNECT";
    private static final String MOVE = "MOVE";
    private static final String PATCH = "PATCH";
    private static final Timer GET_TIMER = Metrics.newTimer(HttpClient.class, (String)"get-requests");
    private static final Timer POST_TIMER = Metrics.newTimer(HttpClient.class, (String)"post-requests");
    private static final Timer HEAD_TIMER = Metrics.newTimer(HttpClient.class, (String)"head-requests");
    private static final Timer PUT_TIMER = Metrics.newTimer(HttpClient.class, (String)"put-requests");
    private static final Timer DELETE_TIMER = Metrics.newTimer(HttpClient.class, (String)"delete-requests");
    private static final Timer OPTIONS_TIMER = Metrics.newTimer(HttpClient.class, (String)"options-requests");
    private static final Timer TRACE_TIMER = Metrics.newTimer(HttpClient.class, (String)"trace-requests");
    private static final Timer CONNECT_TIMER = Metrics.newTimer(HttpClient.class, (String)"connect-requests");
    private static final Timer MOVE_TIMER = Metrics.newTimer(HttpClient.class, (String)"move-requests");
    private static final Timer PATCH_TIMER = Metrics.newTimer(HttpClient.class, (String)"patch-requests");
    private static final Timer OTHER_TIMER = Metrics.newTimer(HttpClient.class, (String)"other-requests");

    InstrumentedRequestDirector(Log log, HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectStrategy redirectStrategy, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler userTokenHandler, HttpParams params) {
        super(log, requestExec, conman, reustrat, kastrat, rouplan, httpProcessor, retryHandler, redirectStrategy, targetAuthHandler, proxyAuthHandler, userTokenHandler, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException, IOException {
        TimerContext timerContext = this.timer(request).time();
        try {
            HttpResponse httpResponse = super.execute(target, request, context);
            return httpResponse;
        }
        finally {
            timerContext.stop();
        }
    }

    private Timer timer(HttpRequest request) {
        String method = request.getRequestLine().getMethod();
        if (GET.equalsIgnoreCase(method)) {
            return GET_TIMER;
        }
        if (POST.equalsIgnoreCase(method)) {
            return POST_TIMER;
        }
        if (PUT.equalsIgnoreCase(method)) {
            return PUT_TIMER;
        }
        if (HEAD.equalsIgnoreCase(method)) {
            return HEAD_TIMER;
        }
        if (DELETE.equalsIgnoreCase(method)) {
            return DELETE_TIMER;
        }
        if (OPTIONS.equalsIgnoreCase(method)) {
            return OPTIONS_TIMER;
        }
        if (TRACE.equalsIgnoreCase(method)) {
            return TRACE_TIMER;
        }
        if (CONNECT.equalsIgnoreCase(method)) {
            return CONNECT_TIMER;
        }
        if (PATCH.equalsIgnoreCase(method)) {
            return PATCH_TIMER;
        }
        if (MOVE.equalsIgnoreCase(method)) {
            return MOVE_TIMER;
        }
        return OTHER_TIMER;
    }
}

