/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.httpclient;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import com.yammer.metrics.httpclient.InstrumentedClientConnManager;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class InstrumentedHttpClient
extends DefaultHttpClient {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String HEAD = "HEAD";
    private static final String PUT = "PUT";
    private static final String OPTIONS = "OPTIONS";
    private static final String DELETE = "DELETE";
    private static final String TRACE = "TRACE";
    private static final String CONNECT = "CONNECT";
    private static final String MOVE = "MOVE";
    private static final String PATCH = "PATCH";
    private static final Timer GET_TIMER = Metrics.newTimer(HttpClient.class, (String)"get-requests");
    private static final Timer POST_TIMER = Metrics.newTimer(HttpClient.class, (String)"post-requests");
    private static final Timer HEAD_TIMER = Metrics.newTimer(HttpClient.class, (String)"head-requests");
    private static final Timer PUT_TIMER = Metrics.newTimer(HttpClient.class, (String)"put-requests");
    private static final Timer DELETE_TIMER = Metrics.newTimer(HttpClient.class, (String)"delete-requests");
    private static final Timer OPTIONS_TIMER = Metrics.newTimer(HttpClient.class, (String)"options-requests");
    private static final Timer TRACE_TIMER = Metrics.newTimer(HttpClient.class, (String)"trace-requests");
    private static final Timer CONNECT_TIMER = Metrics.newTimer(HttpClient.class, (String)"connect-requests");
    private static final Timer MOVE_TIMER = Metrics.newTimer(HttpClient.class, (String)"move-requests");
    private static final Timer PATCH_TIMER = Metrics.newTimer(HttpClient.class, (String)"patch-requests");
    private static final Timer OTHER_TIMER = Metrics.newTimer(HttpClient.class, (String)"other-requests");

    public InstrumentedHttpClient(InstrumentedClientConnManager manager, HttpParams params) {
        super((ClientConnectionManager)manager, params);
    }

    public InstrumentedHttpClient(HttpParams params) {
        super((ClientConnectionManager)new InstrumentedClientConnManager(), params);
    }

    public InstrumentedHttpClient() {
        super((ClientConnectionManager)new InstrumentedClientConnManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        TimerContext context = this.timer((HttpRequest)request).time();
        try {
            Object object = super.execute(request, responseHandler);
            return (T)object;
        }
        finally {
            context.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext ctxt) throws IOException {
        TimerContext context = this.timer((HttpRequest)request).time();
        try {
            Object object = super.execute(request, responseHandler, ctxt);
            return (T)object;
        }
        finally {
            context.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        TimerContext context = this.timer(request).time();
        try {
            Object object = super.execute(target, request, responseHandler);
            return (T)object;
        }
        finally {
            context.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext ctxt) throws IOException {
        TimerContext context = this.timer(request).time();
        try {
            Object object = super.execute(target, request, responseHandler, ctxt);
            return (T)object;
        }
        finally {
            context.stop();
        }
    }

    private Timer timer(HttpRequest request) {
        String method = request.getRequestLine().getMethod();
        if (GET.equalsIgnoreCase(method)) {
            return GET_TIMER;
        }
        if (POST.equalsIgnoreCase(method)) {
            return POST_TIMER;
        }
        if (PUT.equalsIgnoreCase(method)) {
            return PUT_TIMER;
        }
        if (HEAD.equalsIgnoreCase(method)) {
            return HEAD_TIMER;
        }
        if (DELETE.equalsIgnoreCase(method)) {
            return DELETE_TIMER;
        }
        if (OPTIONS.equalsIgnoreCase(method)) {
            return OPTIONS_TIMER;
        }
        if (TRACE.equalsIgnoreCase(method)) {
            return TRACE_TIMER;
        }
        if (CONNECT.equalsIgnoreCase(method)) {
            return CONNECT_TIMER;
        }
        if (PATCH.equalsIgnoreCase(method)) {
            return PATCH_TIMER;
        }
        if (MOVE.equalsIgnoreCase(method)) {
            return MOVE_TIMER;
        }
        return OTHER_TIMER;
    }
}

