/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.task;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.net.Uri;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.yalantis.ucrop.callback.BitmapCropCallback;
import com.yalantis.ucrop.util.BitmapLoadUtils;
import java.io.OutputStream;

public class BitmapCropTask
extends AsyncTask<Void, Void, Exception> {
    private final Context mContext;
    private Bitmap mViewBitmap;
    private final RectF mCropRect;
    private final RectF mCurrentImageRect;
    private final Matrix mTempMatrix = new Matrix();
    private float mCurrentScale;
    private float mCurrentAngle;
    private final int mMaxResultImageSizeX;
    private final int mMaxResultImageSizeY;
    private final Bitmap.CompressFormat mCompressFormat;
    private final int mCompressQuality;
    private final Uri mOutputUri;
    private final BitmapCropCallback mCropCallback;

    public BitmapCropTask(@NonNull Context context, @Nullable Bitmap viewBitmap, @NonNull RectF cropRect, @NonNull RectF currentImageRect, float currentScale, float currentAngle, int maxResultImageSizeX, int maxResultImageSizeY, @NonNull Bitmap.CompressFormat compressFormat, int compressQuality, @NonNull Uri outputUri, @Nullable BitmapCropCallback cropCallback) {
        this.mContext = context;
        this.mViewBitmap = viewBitmap;
        this.mCropRect = cropRect;
        this.mCurrentImageRect = currentImageRect;
        this.mCurrentScale = currentScale;
        this.mCurrentAngle = currentAngle;
        this.mMaxResultImageSizeX = maxResultImageSizeX;
        this.mMaxResultImageSizeY = maxResultImageSizeY;
        this.mCompressFormat = compressFormat;
        this.mCompressQuality = compressQuality;
        this.mOutputUri = outputUri;
        this.mCropCallback = cropCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Exception doInBackground(Void ... params) {
        if (this.mViewBitmap == null || this.mViewBitmap.isRecycled()) {
            return new NullPointerException("ViewBitmap is null or already recycled");
        }
        if (this.mCurrentImageRect.isEmpty()) {
            return new NullPointerException("CurrentImageRect is empty");
        }
        if (this.mMaxResultImageSizeX > 0 && this.mMaxResultImageSizeY > 0) {
            this.resize();
        }
        if (this.mCurrentAngle != 0.0f) {
            this.rotate();
        }
        this.crop();
        OutputStream outputStream = null;
        try {
            outputStream = this.mContext.getContentResolver().openOutputStream(this.mOutputUri);
            this.mViewBitmap.compress(this.mCompressFormat, this.mCompressQuality, outputStream);
            this.mViewBitmap.recycle();
            this.mViewBitmap = null;
        }
        catch (Exception e) {
            Exception exception;
            try {
                exception = e;
            }
            catch (Throwable throwable) {
                BitmapLoadUtils.close(outputStream);
                throw throwable;
            }
            BitmapLoadUtils.close(outputStream);
            return exception;
        }
        BitmapLoadUtils.close(outputStream);
        return null;
    }

    private void resize() {
        float cropWidth = this.mCropRect.width() / this.mCurrentScale;
        float cropHeight = this.mCropRect.height() / this.mCurrentScale;
        if (cropWidth > (float)this.mMaxResultImageSizeX || cropHeight > (float)this.mMaxResultImageSizeY) {
            float scaleX = (float)this.mMaxResultImageSizeX / cropWidth;
            float scaleY = (float)this.mMaxResultImageSizeY / cropHeight;
            float resizeScale = Math.min(scaleX, scaleY);
            Bitmap resizedBitmap = Bitmap.createScaledBitmap((Bitmap)this.mViewBitmap, (int)Math.round((float)this.mViewBitmap.getWidth() * resizeScale), (int)Math.round((float)this.mViewBitmap.getHeight() * resizeScale), (boolean)false);
            if (this.mViewBitmap != resizedBitmap) {
                this.mViewBitmap.recycle();
            }
            this.mViewBitmap = resizedBitmap;
            this.mCurrentScale /= resizeScale;
        }
    }

    private void rotate() {
        this.mTempMatrix.reset();
        this.mTempMatrix.setRotate(this.mCurrentAngle, (float)(this.mViewBitmap.getWidth() / 2), (float)(this.mViewBitmap.getHeight() / 2));
        Bitmap rotatedBitmap = Bitmap.createBitmap((Bitmap)this.mViewBitmap, (int)0, (int)0, (int)this.mViewBitmap.getWidth(), (int)this.mViewBitmap.getHeight(), (Matrix)this.mTempMatrix, (boolean)true);
        if (this.mViewBitmap != rotatedBitmap) {
            this.mViewBitmap.recycle();
        }
        this.mViewBitmap = rotatedBitmap;
    }

    private void crop() {
        int top = Math.round((this.mCropRect.top - this.mCurrentImageRect.top) / this.mCurrentScale);
        int left = Math.round((this.mCropRect.left - this.mCurrentImageRect.left) / this.mCurrentScale);
        int width = Math.round(this.mCropRect.width() / this.mCurrentScale);
        int height = Math.round(this.mCropRect.height() / this.mCurrentScale);
        this.mViewBitmap = Bitmap.createBitmap((Bitmap)this.mViewBitmap, (int)left, (int)top, (int)width, (int)height);
    }

    protected void onPostExecute(@Nullable Exception result) {
        if (this.mCropCallback != null) {
            if (result == null) {
                this.mCropCallback.onBitmapCropped();
            } else {
                this.mCropCallback.onCropFailure(result);
            }
        }
    }
}

