/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.yalantis.ucrop.util.ImageHeaderParser;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class BitmapLoadUtils {
    private static final String TAG = "BitmapLoadUtils";

    public static void decodeBitmapInBackground(@NonNull Context context, @Nullable Uri uri, int requiredWidth, int requiredHeight, BitmapLoadCallback loadCallback) {
        new BitmapWorkerTask(context, uri, requiredWidth, requiredHeight, loadCallback).execute(new Void[0]);
    }

    public static Bitmap transformBitmap(@NonNull Bitmap bitmap, @NonNull Matrix transformMatrix) {
        try {
            Bitmap converted = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)transformMatrix, (boolean)true);
            if (bitmap != converted) {
                bitmap.recycle();
                bitmap = converted;
            }
        }
        catch (OutOfMemoryError error) {
            Log.e((String)TAG, (String)"transformBitmap: ", (Throwable)error);
        }
        return bitmap;
    }

    public static int calculateInSampleSize(@NonNull BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            while (height / inSampleSize > reqHeight || width / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    private static int getExifOrientation(@NonNull Context context, @NonNull Uri imageUri) {
        int orientation = 0;
        try {
            InputStream stream = context.getContentResolver().openInputStream(imageUri);
            if (stream == null) {
                return orientation;
            }
            orientation = new ImageHeaderParser(stream).getOrientation();
            BitmapLoadUtils.close(stream);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("getExifOrientation: " + imageUri.toString()), (Throwable)e);
        }
        return orientation;
    }

    private static int exifToDegrees(int exifOrientation) {
        int rotation;
        switch (exifOrientation) {
            case 5: 
            case 6: {
                rotation = 90;
                break;
            }
            case 3: 
            case 4: {
                rotation = 180;
                break;
            }
            case 7: 
            case 8: {
                rotation = 270;
                break;
            }
            default: {
                rotation = 0;
            }
        }
        return rotation;
    }

    private static int exifToTranslation(int exifOrientation) {
        int translation;
        switch (exifOrientation) {
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                translation = -1;
                break;
            }
            default: {
                translation = 1;
            }
        }
        return translation;
    }

    public static void close(@Nullable Closeable c) {
        if (c != null && c instanceof Closeable) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class BitmapWorkerTask
    extends AsyncTask<Void, Void, BitmapWorkerResult> {
        private final Context mContext;
        private final Uri mUri;
        private final int mRequiredWidth;
        private final int mRequiredHeight;
        private final BitmapLoadCallback mBitmapLoadCallback;

        public BitmapWorkerTask(@NonNull Context context, @Nullable Uri uri, int requiredWidth, int requiredHeight, BitmapLoadCallback loadCallback) {
            this.mContext = context;
            this.mUri = uri;
            this.mRequiredWidth = requiredWidth;
            this.mRequiredHeight = requiredHeight;
            this.mBitmapLoadCallback = loadCallback;
        }

        @NonNull
        protected BitmapWorkerResult doInBackground(Void ... params) {
            ParcelFileDescriptor parcelFileDescriptor;
            if (this.mUri == null) {
                return new BitmapWorkerResult(null, new NullPointerException("Uri cannot be null"));
            }
            try {
                parcelFileDescriptor = this.mContext.getContentResolver().openFileDescriptor(this.mUri, "r");
            }
            catch (FileNotFoundException e) {
                return new BitmapWorkerResult(null, e);
            }
            if (parcelFileDescriptor == null) {
                return new BitmapWorkerResult(null, new NullPointerException("ParcelFileDescriptor was null for given Uri"));
            }
            FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
            options.inSampleSize = BitmapLoadUtils.calculateInSampleSize(options, this.mRequiredWidth, this.mRequiredHeight);
            options.inJustDecodeBounds = false;
            Bitmap decodeSampledBitmap = null;
            boolean success = false;
            while (!success) {
                try {
                    decodeSampledBitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
                    success = true;
                }
                catch (OutOfMemoryError error) {
                    Log.e((String)BitmapLoadUtils.TAG, (String)"doInBackground: BitmapFactory.decodeFileDescriptor: ", (Throwable)error);
                    ++options.inSampleSize;
                }
            }
            if (Build.VERSION.SDK_INT >= 16) {
                BitmapLoadUtils.close((Closeable)parcelFileDescriptor);
            }
            int exifOrientation = BitmapLoadUtils.getExifOrientation(this.mContext, this.mUri);
            int exifDegrees = BitmapLoadUtils.exifToDegrees(exifOrientation);
            int exifTranslation = BitmapLoadUtils.exifToTranslation(exifOrientation);
            Matrix matrix = new Matrix();
            if (exifDegrees != 0) {
                matrix.preRotate((float)exifDegrees);
            }
            if (exifTranslation != 1) {
                matrix.postScale((float)exifTranslation, 1.0f);
            }
            if (!matrix.isIdentity()) {
                return new BitmapWorkerResult(BitmapLoadUtils.transformBitmap(decodeSampledBitmap, matrix), null);
            }
            return new BitmapWorkerResult(decodeSampledBitmap, null);
        }

        protected void onPostExecute(@NonNull BitmapWorkerResult result) {
            if (result.mBitmapWorkerException == null) {
                this.mBitmapLoadCallback.onBitmapLoaded(result.mBitmapResult);
            } else {
                this.mBitmapLoadCallback.onFailure(result.mBitmapWorkerException);
            }
        }
    }

    static class BitmapWorkerResult {
        Bitmap mBitmapResult;
        Exception mBitmapWorkerException;

        public BitmapWorkerResult(@Nullable Bitmap bitmapResult, @Nullable Exception bitmapWorkerException) {
            this.mBitmapResult = bitmapResult;
            this.mBitmapWorkerException = bitmapWorkerException;
        }
    }

    public static interface BitmapLoadCallback {
        public void onBitmapLoaded(@NonNull Bitmap var1);

        public void onFailure(@NonNull Exception var1);
    }
}

