/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.phoenix;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.AbsListView;
import android.widget.ImageView;
import com.yalantis.phoenix.R;
import com.yalantis.phoenix.refresh_view.BaseRefreshView;
import com.yalantis.phoenix.refresh_view.SunRefreshView;
import com.yalantis.phoenix.util.Utils;
import java.security.InvalidParameterException;

public class PullToRefreshView
extends ViewGroup {
    private static final int DRAG_MAX_DISTANCE = 120;
    private static final float DRAG_RATE = 0.5f;
    private static final float DECELERATE_INTERPOLATION_FACTOR = 2.0f;
    public static final int STYLE_SUN = 0;
    public static final int MAX_OFFSET_ANIMATION_DURATION = 700;
    private static final int INVALID_POINTER = -1;
    private View mTarget;
    private ImageView mRefreshView;
    private Interpolator mDecelerateInterpolator;
    private int mTouchSlop;
    private int mTotalDragDistance;
    private BaseRefreshView mBaseRefreshView;
    private float mCurrentDragPercent;
    private int mCurrentOffsetTop;
    private boolean mRefreshing;
    private int mActivePointerId;
    private boolean mIsBeingDragged;
    private float mInitialMotionY;
    private int mFrom;
    private float mFromDragPercent;
    private boolean mNotify;
    private OnRefreshListener mListener;
    private int mTargetPaddingTop;
    private int mTargetPaddingBottom;
    private int mTargetPaddingRight;
    private int mTargetPaddingLeft;
    private final Animation mAnimateToStartPosition = new Animation(){

        public void applyTransformation(float interpolatedTime, Transformation t) {
            PullToRefreshView.this.moveToStart(interpolatedTime);
        }
    };
    private final Animation mAnimateToCorrectPosition = new Animation(){

        public void applyTransformation(float interpolatedTime, Transformation t) {
            int endTarget = PullToRefreshView.this.mTotalDragDistance;
            int targetTop = PullToRefreshView.this.mFrom + (int)((float)(endTarget - PullToRefreshView.this.mFrom) * interpolatedTime);
            int offset = targetTop - PullToRefreshView.this.mTarget.getTop();
            PullToRefreshView.this.mCurrentDragPercent = PullToRefreshView.this.mFromDragPercent - (PullToRefreshView.this.mFromDragPercent - 1.0f) * interpolatedTime;
            PullToRefreshView.this.mBaseRefreshView.setPercent(PullToRefreshView.this.mCurrentDragPercent, false);
            PullToRefreshView.this.setTargetOffsetTop(offset, false);
        }
    };
    private Animation.AnimationListener mToStartListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            PullToRefreshView.this.mBaseRefreshView.stop();
            PullToRefreshView.this.mCurrentOffsetTop = PullToRefreshView.this.mTarget.getTop();
        }
    };

    public PullToRefreshView(Context context) {
        this(context, null);
    }

    public PullToRefreshView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RefreshView);
        int type = a.getInteger(R.styleable.RefreshView_type, 0);
        a.recycle();
        this.mDecelerateInterpolator = new DecelerateInterpolator(2.0f);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mTotalDragDistance = Utils.convertDpToPixel(context, 120);
        this.mRefreshView = new ImageView(context);
        this.setRefreshStyle(type);
        this.addView((View)this.mRefreshView);
        this.setWillNotDraw(false);
        ViewCompat.setChildrenDrawingOrderEnabled((ViewGroup)this, (boolean)true);
    }

    public void setRefreshStyle(int type) {
        this.setRefreshing(false);
        switch (type) {
            case 0: {
                this.mBaseRefreshView = new SunRefreshView(this.getContext(), this);
                break;
            }
            default: {
                throw new InvalidParameterException("Type does not exist");
            }
        }
        this.mRefreshView.setImageDrawable((Drawable)this.mBaseRefreshView);
    }

    public void setRefreshViewPadding(int left, int top, int right, int bottom) {
        this.mRefreshView.setPadding(left, top, right, bottom);
    }

    public int getTotalDragDistance() {
        return this.mTotalDragDistance;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.ensureTarget();
        if (this.mTarget == null) {
            return;
        }
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingRight() - this.getPaddingLeft()), (int)0x40000000);
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000);
        this.mTarget.measure(widthMeasureSpec, heightMeasureSpec);
        this.mRefreshView.measure(widthMeasureSpec, heightMeasureSpec);
    }

    private void ensureTarget() {
        if (this.mTarget != null) {
            return;
        }
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (child == this.mRefreshView) continue;
                this.mTarget = child;
                this.mTargetPaddingBottom = this.mTarget.getPaddingBottom();
                this.mTargetPaddingLeft = this.mTarget.getPaddingLeft();
                this.mTargetPaddingRight = this.mTarget.getPaddingRight();
                this.mTargetPaddingTop = this.mTarget.getPaddingTop();
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.isEnabled() || this.canChildScrollUp() || this.mRefreshing) {
            return false;
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 0: {
                this.setTargetOffsetTop(0, true);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.mIsBeingDragged = false;
                float initialMotionY = this.getMotionEventY(ev, this.mActivePointerId);
                if (initialMotionY == -1.0f) {
                    return false;
                }
                this.mInitialMotionY = initialMotionY;
                break;
            }
            case 2: {
                if (this.mActivePointerId == -1) {
                    return false;
                }
                float y = this.getMotionEventY(ev, this.mActivePointerId);
                if (y == -1.0f) {
                    return false;
                }
                float yDiff = y - this.mInitialMotionY;
                if (!(yDiff > (float)this.mTouchSlop) || this.mIsBeingDragged) break;
                this.mIsBeingDragged = true;
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(@NonNull MotionEvent ev) {
        if (!this.mIsBeingDragged) {
            return super.onTouchEvent(ev);
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 2: {
                int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                if (pointerIndex < 0) {
                    return false;
                }
                float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                float yDiff = y - this.mInitialMotionY;
                float scrollTop = yDiff * 0.5f;
                this.mCurrentDragPercent = scrollTop / (float)this.mTotalDragDistance;
                if (this.mCurrentDragPercent < 0.0f) {
                    return false;
                }
                float boundedDragPercent = Math.min(1.0f, Math.abs(this.mCurrentDragPercent));
                float extraOS = Math.abs(scrollTop) - (float)this.mTotalDragDistance;
                float slingshotDist = this.mTotalDragDistance;
                float tensionSlingshotPercent = Math.max(0.0f, Math.min(extraOS, slingshotDist * 2.0f) / slingshotDist);
                float tensionPercent = (float)((double)(tensionSlingshotPercent / 4.0f) - Math.pow(tensionSlingshotPercent / 4.0f, 2.0)) * 2.0f;
                float extraMove = slingshotDist * tensionPercent / 2.0f;
                int targetY = (int)(slingshotDist * boundedDragPercent + extraMove);
                this.mBaseRefreshView.setPercent(this.mCurrentDragPercent, true);
                this.setTargetOffsetTop(targetY - this.mCurrentOffsetTop, true);
                break;
            }
            case 5: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                if (this.mActivePointerId == -1) {
                    return false;
                }
                int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                float overScrollTop = (y - this.mInitialMotionY) * 0.5f;
                this.mIsBeingDragged = false;
                if (overScrollTop > (float)this.mTotalDragDistance) {
                    this.setRefreshing(true, true);
                } else {
                    this.mRefreshing = false;
                    this.animateOffsetToStartPosition();
                }
                this.mActivePointerId = -1;
                return false;
            }
        }
        return true;
    }

    private void animateOffsetToStartPosition() {
        this.mFrom = this.mCurrentOffsetTop;
        this.mFromDragPercent = this.mCurrentDragPercent;
        long animationDuration = Math.abs((long)(700.0f * this.mFromDragPercent));
        this.mAnimateToStartPosition.reset();
        this.mAnimateToStartPosition.setDuration(animationDuration);
        this.mAnimateToStartPosition.setInterpolator(this.mDecelerateInterpolator);
        this.mAnimateToStartPosition.setAnimationListener(this.mToStartListener);
        this.mRefreshView.clearAnimation();
        this.mRefreshView.startAnimation(this.mAnimateToStartPosition);
    }

    private void animateOffsetToCorrectPosition() {
        this.mFrom = this.mCurrentOffsetTop;
        this.mFromDragPercent = this.mCurrentDragPercent;
        this.mAnimateToCorrectPosition.reset();
        this.mAnimateToCorrectPosition.setDuration(700L);
        this.mAnimateToCorrectPosition.setInterpolator(this.mDecelerateInterpolator);
        this.mRefreshView.clearAnimation();
        this.mRefreshView.startAnimation(this.mAnimateToCorrectPosition);
        if (this.mRefreshing) {
            this.mBaseRefreshView.start();
            if (this.mNotify && this.mListener != null) {
                this.mListener.onRefresh();
            }
        } else {
            this.mBaseRefreshView.stop();
            this.animateOffsetToStartPosition();
        }
        this.mCurrentOffsetTop = this.mTarget.getTop();
        this.mTarget.setPadding(this.mTargetPaddingLeft, this.mTargetPaddingTop, this.mTargetPaddingRight, this.mTotalDragDistance);
    }

    private void moveToStart(float interpolatedTime) {
        int targetTop = this.mFrom - (int)((float)this.mFrom * interpolatedTime);
        float targetPercent = this.mFromDragPercent * (1.0f - interpolatedTime);
        int offset = targetTop - this.mTarget.getTop();
        this.mCurrentDragPercent = targetPercent;
        this.mBaseRefreshView.setPercent(this.mCurrentDragPercent, true);
        this.mTarget.setPadding(this.mTargetPaddingLeft, this.mTargetPaddingTop, this.mTargetPaddingRight, this.mTargetPaddingBottom + targetTop);
        this.setTargetOffsetTop(offset, false);
    }

    public void setRefreshing(boolean refreshing) {
        if (this.mRefreshing != refreshing) {
            this.setRefreshing(refreshing, false);
        }
    }

    private void setRefreshing(boolean refreshing, boolean notify) {
        if (this.mRefreshing != refreshing) {
            this.mNotify = notify;
            this.ensureTarget();
            this.mRefreshing = refreshing;
            if (this.mRefreshing) {
                this.mBaseRefreshView.setPercent(1.0f, true);
                this.animateOffsetToCorrectPosition();
            } else {
                this.animateOffsetToStartPosition();
            }
        }
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
        }
    }

    private float getMotionEventY(MotionEvent ev, int activePointerId) {
        int index = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)activePointerId);
        if (index < 0) {
            return -1.0f;
        }
        return MotionEventCompat.getY((MotionEvent)ev, (int)index);
    }

    private void setTargetOffsetTop(int offset, boolean requiresUpdate) {
        this.mTarget.offsetTopAndBottom(offset);
        this.mBaseRefreshView.offsetTopAndBottom(offset);
        this.mCurrentOffsetTop = this.mTarget.getTop();
        if (requiresUpdate && Build.VERSION.SDK_INT < 11) {
            this.invalidate();
        }
    }

    private boolean canChildScrollUp() {
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mTarget instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mTarget;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return this.mTarget.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.mTarget, (int)-1);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.ensureTarget();
        if (this.mTarget == null) {
            return;
        }
        int height = this.getMeasuredHeight();
        int width = this.getMeasuredWidth();
        int left = this.getPaddingLeft();
        int top = this.getPaddingTop();
        int right = this.getPaddingRight();
        int bottom = this.getPaddingBottom();
        this.mTarget.layout(left, top + this.mCurrentOffsetTop, left + width - right, top + height - bottom + this.mCurrentOffsetTop);
        this.mRefreshView.layout(left, top, left + width - right, top + height - bottom);
    }

    public void setOnRefreshListener(OnRefreshListener listener) {
        this.mListener = listener;
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }
}

