/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.protect.Process;
import com.yahoo.vespa.zookeeper.Configurator;
import com.yahoo.vespa.zookeeper.ExponentialBackoff;
import com.yahoo.vespa.zookeeper.QuorumPeer;
import com.yahoo.vespa.zookeeper.ReconfigException;
import com.yahoo.vespa.zookeeper.Sleeper;
import com.yahoo.vespa.zookeeper.VespaZooKeeperAdmin;
import com.yahoo.vespa.zookeeper.ZooKeeperRunner;
import com.yahoo.vespa.zookeeper.server.VespaZooKeeperServer;
import com.yahoo.yolean.Exceptions;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Reconfigurer
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(Reconfigurer.class.getName());
    static final Duration TIMEOUT = Duration.ofMinutes(15L);
    private final ExponentialBackoff backoff = new ExponentialBackoff(Duration.ofMillis(50L), Duration.ofSeconds(10L));
    private final Duration timeout;
    private final boolean haltOnFailure;
    private final VespaZooKeeperAdmin vespaZooKeeperAdmin;
    private final Sleeper sleeper;
    private QuorumPeer peer;
    private ZooKeeperRunner zooKeeperRunner;
    private ZookeeperServerConfig activeConfig;

    @Inject
    public Reconfigurer(VespaZooKeeperAdmin vespaZooKeeperAdmin) {
        this(vespaZooKeeperAdmin, new Sleeper(), true, TIMEOUT);
    }

    public Reconfigurer(VespaZooKeeperAdmin vespaZooKeeperAdmin, Sleeper sleeper, boolean haltOnFailure, Duration timeout) {
        this.vespaZooKeeperAdmin = Objects.requireNonNull(vespaZooKeeperAdmin);
        this.sleeper = Objects.requireNonNull(sleeper);
        this.haltOnFailure = haltOnFailure;
        this.timeout = timeout;
    }

    public void deconstruct() {
        this.shutdown();
    }

    QuorumPeer startOrReconfigure(ZookeeperServerConfig newConfig, VespaZooKeeperServer server, Supplier<QuorumPeer> quorumPeerCreator) {
        if (this.zooKeeperRunner == null) {
            this.peer = quorumPeerCreator.get();
            this.zooKeeperRunner = this.startServer(newConfig, server);
        }
        if (newConfig.dynamicReconfiguration()) {
            this.reconfigure(newConfig);
        }
        return this.peer;
    }

    ZookeeperServerConfig activeConfig() {
        return this.activeConfig;
    }

    void shutdown() {
        if (this.zooKeeperRunner != null) {
            this.zooKeeperRunner.shutdown();
        }
    }

    private ZooKeeperRunner startServer(ZookeeperServerConfig zookeeperServerConfig, VespaZooKeeperServer server) {
        ZooKeeperRunner runner = new ZooKeeperRunner(zookeeperServerConfig, server);
        this.activeConfig = zookeeperServerConfig;
        return runner;
    }

    private void reconfigure(ZookeeperServerConfig newConfig) {
        Instant reconfigTriggered = Instant.now();
        String newServers = Reconfigurer.servers(newConfig);
        log.log(Level.INFO, "Will reconfigure ZooKeeper cluster.\nServers in active config:" + Reconfigurer.servers(this.activeConfig) + "\nServers in new config:" + newServers);
        String connectionSpec = this.vespaZooKeeperAdmin.localConnectionSpec(this.activeConfig);
        Instant now = Instant.now();
        Instant end = now.plus(this.timeout);
        int attempt = 1;
        while (true) {
            try {
                Instant reconfigStarted = Instant.now();
                this.vespaZooKeeperAdmin.reconfigure(connectionSpec, newServers);
                Instant reconfigEnded = Instant.now();
                log.log(Level.INFO, "Reconfiguration completed in " + Duration.between(reconfigTriggered, reconfigEnded) + ", after " + attempt + " attempt(s). ZooKeeper reconfig call took " + Duration.between(reconfigStarted, reconfigEnded));
                this.activeConfig = newConfig;
                return;
            }
            catch (ReconfigException e) {
                Duration delay = this.backoff.delay(attempt);
                now = Instant.now();
                if (now.isBefore(end)) {
                    log.log(Level.INFO, "Reconfiguration attempt " + attempt + " failed. Retrying in " + delay + ", time left " + Duration.between(now, end) + ": " + Exceptions.toMessageString((Throwable)e));
                    this.sleeper.sleep(delay);
                } else {
                    log.log(Level.SEVERE, "Reconfiguration attempt " + attempt + " failed, and was failing for " + this.timeout + "; giving up now: " + Exceptions.toMessageString((Throwable)e));
                    this.shutdown();
                    if (this.haltOnFailure) {
                        Process.logAndDie((String)("Reconfiguration did not complete within timeout " + this.timeout + ". Forcing container shutdown."));
                    } else {
                        throw e;
                    }
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static String servers(ZookeeperServerConfig config) {
        return Configurator.getServerConfig(config.server().stream().filter(server -> !server.retired()).toList(), -1).entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(","));
    }
}

