/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.security.tls.ConfigFileBasedTlsContext;
import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityUtils;
import com.yahoo.stream.CustomCollectors;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.zookeeper.VespaSslContextProvider;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Configurator {
    public static volatile boolean VespaNettyServerCnxnFactory_isSecure = false;
    private static final Logger log = Logger.getLogger(Configurator.class.getName());
    private static final String ZOOKEEPER_JMX_LOG4J_DISABLE = "zookeeper.jmx.log4j.disable";
    static final String ZOOKEEPER_JUTE_MAX_BUFFER = "jute.maxbuffer";
    private final ZookeeperServerConfig zookeeperServerConfig;
    private final Path configFilePath;

    public Configurator(ZookeeperServerConfig zookeeperServerConfig) {
        log.log(Level.FINE, zookeeperServerConfig.toString());
        this.zookeeperServerConfig = zookeeperServerConfig;
        this.configFilePath = this.makeAbsolutePath(zookeeperServerConfig.zooKeeperConfigFile());
        System.setProperty(ZOOKEEPER_JMX_LOG4J_DISABLE, "true");
        System.setProperty("zookeeper.snapshot.trust.empty", String.valueOf(zookeeperServerConfig.trustEmptySnapshot()));
        System.setProperty(ZOOKEEPER_JUTE_MAX_BUFFER, Integer.valueOf(zookeeperServerConfig.juteMaxBuffer()).toString());
        System.setProperty("zookeeper.authProvider.x509", "com.yahoo.vespa.zookeeper.VespaMtlsAuthenticationProvider");
        System.setProperty("zookeeper.globalOutstandingLimit", "1000");
        System.setProperty("zookeeper.snapshot.compression.method", zookeeperServerConfig.snapshotMethod());
        System.setProperty("zookeeper.leader.closeSocketAsync", String.valueOf(zookeeperServerConfig.leaderCloseSocketAsync()));
        System.setProperty("zookeeper.learner.asyncSending", String.valueOf(zookeeperServerConfig.learnerAsyncSending()));
        System.setProperty("zookeeper.extendedTypesEnabled", "true");
    }

    void writeConfigToDisk() {
        String cfgFile = this.zookeeperServerConfig.vespaTlsConfigFile();
        VespaTlsConfig config = cfgFile.isBlank() ? VespaTlsConfig.fromSystem() : VespaTlsConfig.fromConfig(Paths.get(cfgFile, new String[0]));
        this.writeConfigToDisk(config);
    }

    void writeConfigToDisk(VespaTlsConfig vespaTlsConfig) {
        this.configFilePath.toFile().getParentFile().mkdirs();
        try {
            this.writeZooKeeperConfigFile(this.zookeeperServerConfig, vespaTlsConfig);
            this.writeMyIdFile(this.zookeeperServerConfig);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing zookeeper config", e);
        }
    }

    private void writeZooKeeperConfigFile(ZookeeperServerConfig config, VespaTlsConfig vespaTlsConfig) throws IOException {
        String dynamicConfigPath = config.dynamicReconfiguration() ? Configurator.parseConfigFile(this.configFilePath).get("dynamicConfigFile") : null;
        Map<String, String> dynamicConfig = dynamicConfigPath != null ? Configurator.parseConfigFile(Paths.get(dynamicConfigPath, new String[0])) : Map.of();
        try (FileWriter writer = new FileWriter(this.configFilePath.toFile());){
            writer.write(this.transformConfigToString(config, vespaTlsConfig, dynamicConfig));
        }
    }

    private String transformConfigToString(ZookeeperServerConfig config, VespaTlsConfig vespaTlsConfig, Map<String, String> dynamicConfig) {
        LinkedHashMap<String, String> configEntries = new LinkedHashMap<String, String>();
        configEntries.put("tickTime", Integer.toString(config.tickTime()));
        configEntries.put("initLimit", Integer.toString(config.initLimit()));
        configEntries.put("syncLimit", Integer.toString(config.syncLimit()));
        configEntries.put("maxClientCnxns", Integer.toString(config.maxClientConnections()));
        configEntries.put("snapCount", Integer.toString(config.snapshotCount()));
        configEntries.put("dataDir", Defaults.getDefaults().underVespaHome(config.dataDir()));
        configEntries.put("autopurge.purgeInterval", Integer.toString(config.autopurge().purgeInterval()));
        configEntries.put("autopurge.snapRetainCount", Integer.toString(config.autopurge().snapRetainCount()));
        configEntries.put("4lw.commands.whitelist", "conf,cons,crst,dirs,dump,envi,mntr,ruok,srst,srvr,stat,wchs");
        configEntries.put("admin.enableServer", "false");
        configEntries.put("serverCnxnFactory", "org.apache.zookeeper.server.VespaNettyServerCnxnFactory");
        configEntries.put("quorumListenOnAllIPs", "true");
        configEntries.put("standaloneEnabled", "false");
        configEntries.put("reconfigEnabled", Boolean.toString(config.dynamicReconfiguration()));
        configEntries.put("skipACL", "yes");
        this.addServerSpecs(configEntries, config, dynamicConfig);
        new TlsQuorumConfig().createConfig(configEntries, vespaTlsConfig);
        new TlsClientServerConfig().createConfig(configEntries, vespaTlsConfig);
        return Configurator.transformConfigToString(configEntries);
    }

    void addServerSpecs(Map<String, String> configEntries, ZookeeperServerConfig config, Map<String, String> dynamicConfig) {
        int myIndex = Configurator.ensureThisServerIsRepresented(config.myid(), config.server());
        Set currentServers = config.server().stream().map(ZookeeperServerConfig.Server::hostname).collect(Collectors.toSet());
        if (dynamicConfig.values().stream().anyMatch(spec -> !currentServers.contains(spec.split(":", 2)[0]))) {
            log.log(Level.WARNING, "Existing dynamic config refers to unknown servers, ignoring it");
            dynamicConfig = Map.of();
        }
        if (dynamicConfig.isEmpty()) {
            configEntries.putAll(Configurator.getServerConfig(config.server(), config.server(myIndex).joining() ? config.myid() : -1));
        } else {
            Map.Entry<String, String> thisAsAJoiner = Configurator.getServerConfig(config.server().subList(myIndex, myIndex + 1), config.myid()).entrySet().iterator().next();
            dynamicConfig.putIfAbsent(thisAsAJoiner.getKey(), thisAsAJoiner.getValue());
            configEntries.putAll(dynamicConfig);
        }
    }

    static Map<String, String> getServerConfig(List<ZookeeperServerConfig.Server> serversConfig, int joinerId) {
        LinkedHashMap<String, String> configEntries = new LinkedHashMap<String, String>();
        for (ZookeeperServerConfig.Server server : serversConfig) {
            configEntries.put("server." + server.id(), Configurator.serverSpec(server, server.id() == joinerId));
        }
        return configEntries;
    }

    static String transformConfigToString(Map<String, String> config) {
        return config.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("\n", "", "\n"));
    }

    private void writeMyIdFile(ZookeeperServerConfig config) throws IOException {
        try (FileWriter writer = new FileWriter(Defaults.getDefaults().underVespaHome(config.myidFile()));){
            writer.write(config.myid() + "\n");
        }
    }

    private static int ensureThisServerIsRepresented(int myid, List<ZookeeperServerConfig.Server> servers) {
        for (int i = 0; i < servers.size(); ++i) {
            ZookeeperServerConfig.Server server = servers.get(i);
            if (myid != server.id()) continue;
            return i;
        }
        throw new RuntimeException("No id in zookeeper server list that corresponds to my id (" + myid + ")");
    }

    static String serverSpec(ZookeeperServerConfig.Server server, boolean joining) {
        StringBuilder sb = new StringBuilder();
        sb.append(server.hostname()).append(":").append(server.quorumPort()).append(":").append(server.electionPort());
        if (joining) {
            sb.append(":").append("observer");
        }
        sb.append(";").append(server.clientPort());
        return sb.toString();
    }

    static Map<String, String> parseConfigFile(Path configFilePath) {
        try {
            return Files.exists(configFilePath, new LinkOption[0]) ? (Map)Files.readAllLines(configFilePath).stream().filter(line -> !line.startsWith("#")).map(line -> line.split("=", 2)).collect(CustomCollectors.toLinkedMap(parts -> parts[0], parts -> parts[1])) : Map.of();
        }
        catch (IOException e) {
            throw new UncheckedIOException("error reading zookeeper config", e);
        }
    }

    static List<String> zookeeperServerHostnames(ZookeeperServerConfig zookeeperServerConfig) {
        return zookeeperServerConfig.server().stream().map(ZookeeperServerConfig.Server::hostname).distinct().toList();
    }

    Path makeAbsolutePath(String filename) {
        Path path = Paths.get(filename, new String[0]);
        return path.isAbsolute() ? path : Paths.get(Defaults.getDefaults().underVespaHome(filename), new String[0]);
    }

    static class VespaTlsConfig {
        private final TlsContext context;
        private final MixedMode mixedMode;

        VespaTlsConfig(TlsContext context, MixedMode mixedMode) {
            this.context = context;
            this.mixedMode = mixedMode;
        }

        static VespaTlsConfig fromSystem() {
            return new VespaTlsConfig(TransportSecurityUtils.getSystemTlsContext().orElse(null), TransportSecurityUtils.getInsecureMixedMode());
        }

        static VespaTlsConfig fromConfig(Path file) {
            return new VespaTlsConfig((TlsContext)new ConfigFileBasedTlsContext(file, TransportSecurityUtils.getInsecureAuthorizationMode()), TransportSecurityUtils.getInsecureMixedMode());
        }

        static VespaTlsConfig tlsDisabled() {
            return new VespaTlsConfig(null, MixedMode.defaultValue());
        }

        boolean tlsEnabled() {
            return this.context != null;
        }

        Optional<TlsContext> context() {
            return Optional.ofNullable(this.context);
        }

        MixedMode mixedMode() {
            return this.mixedMode;
        }
    }

    static class TlsQuorumConfig
    implements TlsConfig {
        TlsQuorumConfig() {
        }

        public void createConfig(Map<String, String> configEntries, VespaTlsConfig vespaTlsConfig) {
            configEntries.put("sslQuorum", String.valueOf(vespaTlsConfig.tlsEnabled()));
            configEntries.put("portUnification", String.valueOf(this.enablePortUnification(vespaTlsConfig)));
            this.appendSharedTlsConfig(configEntries, vespaTlsConfig);
        }

        @Override
        public String configFieldPrefix() {
            return "ssl.quorum";
        }
    }

    static class TlsClientServerConfig
    implements TlsConfig {
        TlsClientServerConfig() {
        }

        public void createConfig(Map<String, String> configEntries, VespaTlsConfig vespaTlsConfig) {
            configEntries.put("client.portUnification", String.valueOf(this.enablePortUnification(vespaTlsConfig)));
            VespaNettyServerCnxnFactory_isSecure = vespaTlsConfig.tlsEnabled() && vespaTlsConfig.mixedMode() == MixedMode.DISABLED;
            this.appendSharedTlsConfig(configEntries, vespaTlsConfig);
        }

        @Override
        public String configFieldPrefix() {
            return "ssl";
        }
    }

    private static interface TlsConfig {
        public String configFieldPrefix();

        default public void appendSharedTlsConfig(Map<String, String> configEntries, VespaTlsConfig vespaTlsConfig) {
            vespaTlsConfig.context().ifPresent(ctx -> {
                VespaSslContextProvider.set(ctx);
                configEntries.put(this.configFieldPrefix() + ".context.supplier.class", VespaSslContextProvider.class.getName());
                String enabledCiphers = Arrays.stream(ctx.parameters().getCipherSuites()).sorted().collect(Collectors.joining(","));
                configEntries.put(this.configFieldPrefix() + ".ciphersuites", enabledCiphers);
                String enabledProtocols = Arrays.stream(ctx.parameters().getProtocols()).sorted().collect(Collectors.joining(","));
                configEntries.put(this.configFieldPrefix() + ".enabledProtocols", enabledProtocols);
                configEntries.put(this.configFieldPrefix() + ".clientAuth", "NEED");
            });
        }

        default public boolean enablePortUnification(VespaTlsConfig config) {
            return config.tlsEnabled() && (config.mixedMode() == MixedMode.TLS_CLIENT_MIXED_SERVER || config.mixedMode() == MixedMode.PLAINTEXT_CLIENT_MIXED_SERVER);
        }
    }
}

