/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.security.tls.ConfigFileBasedTlsContext;
import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityUtils;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.zookeeper.VespaSslContextProvider;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Configurator {
    public static volatile boolean VespaNettyServerCnxnFactory_isSecure = false;
    private static final Logger log = Logger.getLogger(Configurator.class.getName());
    private static final String ZOOKEEPER_JMX_LOG4J_DISABLE = "zookeeper.jmx.log4j.disable";
    static final String ZOOKEEPER_JUTE_MAX_BUFFER = "jute.maxbuffer";
    private final ZookeeperServerConfig zookeeperServerConfig;
    private final Path configFilePath;

    public Configurator(ZookeeperServerConfig zookeeperServerConfig) {
        log.log(Level.FINE, zookeeperServerConfig.toString());
        this.zookeeperServerConfig = zookeeperServerConfig;
        this.configFilePath = this.makeAbsolutePath(zookeeperServerConfig.zooKeeperConfigFile());
        System.setProperty(ZOOKEEPER_JMX_LOG4J_DISABLE, "true");
        System.setProperty("zookeeper.snapshot.trust.empty", String.valueOf(zookeeperServerConfig.trustEmptySnapshot()));
        System.setProperty(ZOOKEEPER_JUTE_MAX_BUFFER, Integer.valueOf(zookeeperServerConfig.juteMaxBuffer()).toString());
        System.setProperty("zookeeper.authProvider.x509", "com.yahoo.vespa.zookeeper.VespaMtlsAuthenticationProvider");
        System.setProperty("zookeeper.globalOutstandingLimit", "1000");
        System.setProperty("zookeeper.snapshot.compression.method", zookeeperServerConfig.snapshotMethod());
        System.setProperty("zookeeper.leader.closeSocketAsync", String.valueOf(zookeeperServerConfig.leaderCloseSocketAsync()));
        System.setProperty("zookeeper.learner.asyncSending", String.valueOf(zookeeperServerConfig.learnerAsyncSending()));
        System.setProperty("zookeeper.extendedTypesEnabled", "true");
    }

    void writeConfigToDisk() {
        String cfgFile = this.zookeeperServerConfig.vespaTlsConfigFile();
        VespaTlsConfig config = cfgFile.isBlank() ? VespaTlsConfig.fromSystem() : VespaTlsConfig.fromConfig(Paths.get(cfgFile, new String[0]));
        this.writeConfigToDisk(config);
    }

    void writeConfigToDisk(VespaTlsConfig vespaTlsConfig) {
        this.configFilePath.toFile().getParentFile().mkdirs();
        try {
            this.writeZooKeeperConfigFile(this.zookeeperServerConfig, vespaTlsConfig);
            this.writeMyIdFile(this.zookeeperServerConfig);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing zookeeper config", e);
        }
    }

    private void writeZooKeeperConfigFile(ZookeeperServerConfig config, VespaTlsConfig vespaTlsConfig) throws IOException {
        try (FileWriter writer = new FileWriter(this.configFilePath.toFile());){
            writer.write(this.transformConfigToString(config, vespaTlsConfig));
        }
    }

    private String transformConfigToString(ZookeeperServerConfig config, VespaTlsConfig vespaTlsConfig) {
        StringBuilder sb = new StringBuilder();
        sb.append("tickTime=").append(config.tickTime()).append("\n");
        sb.append("initLimit=").append(config.initLimit()).append("\n");
        sb.append("syncLimit=").append(config.syncLimit()).append("\n");
        sb.append("maxClientCnxns=").append(config.maxClientConnections()).append("\n");
        sb.append("snapCount=").append(config.snapshotCount()).append("\n");
        sb.append("dataDir=").append(Defaults.getDefaults().underVespaHome(config.dataDir())).append("\n");
        sb.append("autopurge.purgeInterval=").append(config.autopurge().purgeInterval()).append("\n");
        sb.append("autopurge.snapRetainCount=").append(config.autopurge().snapRetainCount()).append("\n");
        sb.append("4lw.commands.whitelist=conf,cons,crst,dirs,dump,envi,mntr,ruok,srst,srvr,stat,wchs").append("\n");
        sb.append("admin.enableServer=false").append("\n");
        sb.append("serverCnxnFactory=org.apache.zookeeper.server.VespaNettyServerCnxnFactory").append("\n");
        sb.append("quorumListenOnAllIPs=true").append("\n");
        sb.append("standaloneEnabled=false").append("\n");
        sb.append("reconfigEnabled=true").append("\n");
        sb.append("skipACL=yes").append("\n");
        this.ensureThisServerIsRepresented(config.myid(), config.server());
        config.server().forEach(server -> sb.append(Configurator.serverSpec(server, server.joining())).append("\n"));
        sb.append(new TlsQuorumConfig().createConfig(vespaTlsConfig));
        sb.append(new TlsClientServerConfig().createConfig(vespaTlsConfig));
        return sb.toString();
    }

    private void writeMyIdFile(ZookeeperServerConfig config) throws IOException {
        try (FileWriter writer = new FileWriter(Defaults.getDefaults().underVespaHome(config.myidFile()));){
            writer.write(config.myid() + "\n");
        }
    }

    private void ensureThisServerIsRepresented(int myid, List<ZookeeperServerConfig.Server> servers) {
        boolean found = false;
        for (ZookeeperServerConfig.Server server : servers) {
            if (myid != server.id()) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new RuntimeException("No id in zookeeper server list that corresponds to my id (" + myid + ")");
        }
    }

    static String serverSpec(ZookeeperServerConfig.Server server, boolean joining) {
        StringBuilder sb = new StringBuilder();
        sb.append("server.").append(server.id()).append("=").append(server.hostname()).append(":").append(server.quorumPort()).append(":").append(server.electionPort());
        if (joining) {
            sb.append(":").append("observer");
        }
        sb.append(";").append(server.clientPort());
        return sb.toString();
    }

    static List<String> zookeeperServerHostnames(ZookeeperServerConfig zookeeperServerConfig) {
        return zookeeperServerConfig.server().stream().map(ZookeeperServerConfig.Server::hostname).distinct().toList();
    }

    Path makeAbsolutePath(String filename) {
        Path path = Paths.get(filename, new String[0]);
        return path.isAbsolute() ? path : Paths.get(Defaults.getDefaults().underVespaHome(filename), new String[0]);
    }

    static class VespaTlsConfig {
        private final TlsContext context;
        private final MixedMode mixedMode;

        VespaTlsConfig(TlsContext context, MixedMode mixedMode) {
            this.context = context;
            this.mixedMode = mixedMode;
        }

        static VespaTlsConfig fromSystem() {
            return new VespaTlsConfig(TransportSecurityUtils.getSystemTlsContext().orElse(null), TransportSecurityUtils.getInsecureMixedMode());
        }

        static VespaTlsConfig fromConfig(Path file) {
            return new VespaTlsConfig((TlsContext)new ConfigFileBasedTlsContext(file, TransportSecurityUtils.getInsecureAuthorizationMode()), TransportSecurityUtils.getInsecureMixedMode());
        }

        static VespaTlsConfig tlsDisabled() {
            return new VespaTlsConfig(null, MixedMode.defaultValue());
        }

        boolean tlsEnabled() {
            return this.context != null;
        }

        Optional<TlsContext> context() {
            return Optional.ofNullable(this.context);
        }

        MixedMode mixedMode() {
            return this.mixedMode;
        }
    }

    static class TlsQuorumConfig
    implements TlsConfig {
        TlsQuorumConfig() {
        }

        public String createConfig(VespaTlsConfig vespaTlsConfig) {
            StringBuilder sb = new StringBuilder().append("sslQuorum=").append(vespaTlsConfig.tlsEnabled()).append("\n").append("portUnification=").append(this.enablePortUnification(vespaTlsConfig)).append("\n");
            this.appendSharedTlsConfig(sb, vespaTlsConfig);
            return sb.toString();
        }

        @Override
        public String configFieldPrefix() {
            return "ssl.quorum";
        }
    }

    static class TlsClientServerConfig
    implements TlsConfig {
        TlsClientServerConfig() {
        }

        public String createConfig(VespaTlsConfig vespaTlsConfig) {
            StringBuilder sb = new StringBuilder().append("client.portUnification=").append(this.enablePortUnification(vespaTlsConfig)).append("\n");
            VespaNettyServerCnxnFactory_isSecure = vespaTlsConfig.tlsEnabled() && vespaTlsConfig.mixedMode() == MixedMode.DISABLED;
            this.appendSharedTlsConfig(sb, vespaTlsConfig);
            return sb.toString();
        }

        @Override
        public String configFieldPrefix() {
            return "ssl";
        }
    }

    private static interface TlsConfig {
        public String configFieldPrefix();

        default public void appendSharedTlsConfig(StringBuilder builder, VespaTlsConfig vespaTlsConfig) {
            vespaTlsConfig.context().ifPresent(ctx -> {
                VespaSslContextProvider.set(ctx);
                builder.append(this.configFieldPrefix()).append(".context.supplier.class=").append(VespaSslContextProvider.class.getName()).append("\n");
                String enabledCiphers = Arrays.stream(ctx.parameters().getCipherSuites()).sorted().collect(Collectors.joining(","));
                builder.append(this.configFieldPrefix()).append(".ciphersuites=").append(enabledCiphers).append("\n");
                String enabledProtocols = Arrays.stream(ctx.parameters().getProtocols()).sorted().collect(Collectors.joining(","));
                builder.append(this.configFieldPrefix()).append(".enabledProtocols=").append(enabledProtocols).append("\n");
                builder.append(this.configFieldPrefix()).append(".clientAuth=NEED\n");
            });
        }

        default public boolean enablePortUnification(VespaTlsConfig config) {
            return config.tlsEnabled() && (config.mixedMode() == MixedMode.TLS_CLIENT_MIXED_SERVER || config.mixedMode() == MixedMode.PLAINTEXT_CLIENT_MIXED_SERVER);
        }
    }
}

