/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.zookeeper.VespaSslContextProvider;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Configurator {
    public static volatile boolean VespaNettyServerCnxnFactory_isSecure = false;
    private static final Logger log = Logger.getLogger(Configurator.class.getName());
    private static final String ZOOKEEPER_JMX_LOG4J_DISABLE = "zookeeper.jmx.log4j.disable";
    static final String ZOOKEEPER_JUTE_MAX_BUFFER = "jute.maxbuffer";
    private final ZookeeperServerConfig zookeeperServerConfig;
    private final Path configFilePath;

    public Configurator(ZookeeperServerConfig zookeeperServerConfig) {
        log.log(Level.FINE, zookeeperServerConfig.toString());
        this.zookeeperServerConfig = zookeeperServerConfig;
        this.configFilePath = this.makeAbsolutePath(zookeeperServerConfig.zooKeeperConfigFile());
        System.setProperty(ZOOKEEPER_JMX_LOG4J_DISABLE, "true");
        System.setProperty("zookeeper.snapshot.trust.empty", Boolean.valueOf(zookeeperServerConfig.trustEmptySnapshot()).toString());
        System.setProperty(ZOOKEEPER_JUTE_MAX_BUFFER, Integer.valueOf(zookeeperServerConfig.juteMaxBuffer()).toString());
        System.setProperty("zookeeper.authProvider.x509", "com.yahoo.vespa.zookeeper.VespaMtlsAuthenticationProvider");
    }

    void writeConfigToDisk(Optional<TlsContext> tlsContext) {
        this.configFilePath.toFile().getParentFile().mkdirs();
        try {
            this.writeZooKeeperConfigFile(this.zookeeperServerConfig, tlsContext);
            this.writeMyIdFile(this.zookeeperServerConfig);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing zookeeper config", e);
        }
    }

    private void writeZooKeeperConfigFile(ZookeeperServerConfig config, Optional<TlsContext> tlsContext) throws IOException {
        try (FileWriter writer = new FileWriter(this.configFilePath.toFile());){
            writer.write(this.transformConfigToString(config, tlsContext));
        }
    }

    private String transformConfigToString(ZookeeperServerConfig config, Optional<TlsContext> tlsContext) {
        StringBuilder sb = new StringBuilder();
        sb.append("tickTime=").append(config.tickTime()).append("\n");
        sb.append("initLimit=").append(config.initLimit()).append("\n");
        sb.append("syncLimit=").append(config.syncLimit()).append("\n");
        sb.append("maxClientCnxns=").append(config.maxClientConnections()).append("\n");
        sb.append("snapCount=").append(config.snapshotCount()).append("\n");
        sb.append("dataDir=").append(Defaults.getDefaults().underVespaHome(config.dataDir())).append("\n");
        sb.append("autopurge.purgeInterval=").append(config.autopurge().purgeInterval()).append("\n");
        sb.append("autopurge.snapRetainCount=").append(config.autopurge().snapRetainCount()).append("\n");
        sb.append("4lw.commands.whitelist=conf,cons,crst,dirs,dump,envi,mntr,ruok,srst,srvr,stat,wchs").append("\n");
        sb.append("admin.enableServer=false").append("\n");
        sb.append("serverCnxnFactory=org.apache.zookeeper.server.VespaNettyServerCnxnFactory").append("\n");
        sb.append("quorumListenOnAllIPs=true").append("\n");
        sb.append("standaloneEnabled=false").append("\n");
        sb.append("reconfigEnabled=true").append("\n");
        sb.append("skipACL=yes").append("\n");
        this.ensureThisServerIsRepresented(config.myid(), config.server());
        config.server().forEach(server -> this.addServerToCfg(sb, (ZookeeperServerConfig.Server)server, config.clientPort()));
        sb.append(new TlsQuorumConfig().createConfig(config, tlsContext));
        sb.append(new TlsClientServerConfig().createConfig(config, tlsContext));
        return sb.toString();
    }

    private void writeMyIdFile(ZookeeperServerConfig config) throws IOException {
        try (FileWriter writer = new FileWriter(Defaults.getDefaults().underVespaHome(config.myidFile()));){
            writer.write(config.myid() + "\n");
        }
    }

    private void ensureThisServerIsRepresented(int myid, List<ZookeeperServerConfig.Server> servers) {
        boolean found = false;
        for (ZookeeperServerConfig.Server server : servers) {
            if (myid != server.id()) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new RuntimeException("No id in zookeeper server list that corresponds to my id(" + myid + ")");
        }
    }

    private void addServerToCfg(StringBuilder sb, ZookeeperServerConfig.Server server, int clientPort) {
        sb.append("server.").append(server.id()).append("=").append(server.hostname()).append(":").append(server.quorumPort()).append(":").append(server.electionPort());
        if (server.joining()) {
            sb.append(":").append("observer");
        }
        sb.append(";").append(clientPort).append("\n");
    }

    static List<String> zookeeperServerHostnames(ZookeeperServerConfig zookeeperServerConfig) {
        return zookeeperServerConfig.server().stream().map(ZookeeperServerConfig.Server::hostname).distinct().collect(Collectors.toList());
    }

    Path makeAbsolutePath(String filename) {
        Path path = Paths.get(filename, new String[0]);
        if (path.isAbsolute()) {
            return path;
        }
        return Paths.get(Defaults.getDefaults().underVespaHome(filename), new String[0]);
    }

    static class TlsQuorumConfig
    implements TlsConfig {
        TlsQuorumConfig() {
        }

        @Override
        public String createConfig(ZookeeperServerConfig config, Optional<TlsContext> tlsContext) {
            boolean portUnification;
            boolean sslQuorum;
            String tlsSetting = this.getEnvironmentVariable("VESPA_TLS_FOR_ZOOKEEPER_QUORUM_COMMUNICATION").orElse(config.tlsForQuorumCommunication().name());
            this.validateOptions(tlsContext, tlsSetting);
            StringBuilder sb = new StringBuilder();
            switch (tlsSetting) {
                case "OFF": {
                    sslQuorum = false;
                    portUnification = false;
                    break;
                }
                case "PORT_UNIFICATION": {
                    sslQuorum = false;
                    portUnification = true;
                    break;
                }
                case "TLS_WITH_PORT_UNIFICATION": {
                    sslQuorum = true;
                    portUnification = true;
                    break;
                }
                case "TLS_ONLY": {
                    sslQuorum = true;
                    portUnification = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown value of config setting tlsForQuorumCommunication: " + tlsSetting);
                }
            }
            sb.append("sslQuorum=").append(sslQuorum).append("\n");
            sb.append("portUnification=").append(portUnification).append("\n");
            this.appendSharedTlsConfig(sb, tlsContext);
            return sb.toString();
        }

        @Override
        public String configFieldPrefix() {
            return "ssl.quorum";
        }
    }

    static class TlsClientServerConfig
    implements TlsConfig {
        TlsClientServerConfig() {
        }

        @Override
        public String createConfig(ZookeeperServerConfig config, Optional<TlsContext> tlsContext) {
            boolean portUnification;
            boolean secureClientPort;
            String tlsSetting = this.getEnvironmentVariable("VESPA_TLS_FOR_ZOOKEEPER_CLIENT_SERVER_COMMUNICATION").orElse(config.tlsForClientServerCommunication().name());
            this.validateOptions(tlsContext, tlsSetting);
            StringBuilder sb = new StringBuilder();
            switch (tlsSetting) {
                case "OFF": {
                    secureClientPort = false;
                    portUnification = false;
                    break;
                }
                case "TLS_ONLY": {
                    secureClientPort = true;
                    portUnification = false;
                    break;
                }
                case "PORT_UNIFICATION": 
                case "TLS_WITH_PORT_UNIFICATION": {
                    secureClientPort = false;
                    portUnification = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown value of config setting tlsForClientServerCommunication: " + tlsSetting);
                }
            }
            sb.append("client.portUnification=").append(portUnification).append("\n");
            VespaNettyServerCnxnFactory_isSecure = secureClientPort;
            this.appendSharedTlsConfig(sb, tlsContext);
            return sb.toString();
        }

        @Override
        public String configFieldPrefix() {
            return "ssl";
        }
    }

    private static interface TlsConfig {
        public String createConfig(ZookeeperServerConfig var1, Optional<TlsContext> var2);

        default public Optional<String> getEnvironmentVariable(String variableName) {
            return Optional.ofNullable(System.getenv().get(variableName)).filter(var -> !var.isEmpty());
        }

        default public void validateOptions(Optional<TlsContext> tlsContext, String tlsSetting) {
            if (tlsContext.isEmpty() && !tlsSetting.equals("OFF")) {
                throw new RuntimeException("Could not retrieve transport security options");
            }
        }

        public String configFieldPrefix();

        default public void appendSharedTlsConfig(StringBuilder builder, Optional<TlsContext> tlsContext) {
            tlsContext.ifPresent(ctx -> {
                builder.append(this.configFieldPrefix()).append(".context.supplier.class=").append(VespaSslContextProvider.class.getName()).append("\n");
                String enabledCiphers = Arrays.stream(ctx.parameters().getCipherSuites()).sorted().collect(Collectors.joining(","));
                builder.append(this.configFieldPrefix()).append(".ciphersuites=").append(enabledCiphers).append("\n");
                String enabledProtocols = Arrays.stream(ctx.parameters().getProtocols()).sorted().collect(Collectors.joining(","));
                builder.append(this.configFieldPrefix()).append(".enabledProtocols=").append(enabledProtocols).append("\n");
                builder.append(this.configFieldPrefix()).append(".clientAuth=NEED\n");
            });
        }
    }
}

