/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;

public class VespaSslContextProvider
implements Supplier<SSLContext> {
    private static final TlsContext tlsContext = TransportSecurityUtils.getSystemTlsContext().orElse(null);

    @Override
    public SSLContext get() {
        if (!VespaSslContextProvider.tlsEnabled()) {
            throw new IllegalStateException("Vespa TLS is not enabled");
        }
        return tlsContext.context();
    }

    public static boolean tlsEnabled() {
        return tlsContext != null;
    }

    public static String enabledTlsProtocolConfigValue() {
        Set enabledProtocols = VespaSslContextProvider.tlsEnabled() ? List.of(tlsContext.parameters().getProtocols()) : TlsContext.ALLOWED_PROTOCOLS;
        return enabledProtocols.stream().sorted().collect(Collectors.joining(","));
    }

    public static String enabledTlsCiphersConfigValue() {
        Set enabledCiphers = VespaSslContextProvider.tlsEnabled() ? List.of(tlsContext.parameters().getCipherSuites()) : TlsContext.ALLOWED_CIPHER_SUITES;
        return enabledCiphers.stream().sorted().collect(Collectors.joining(","));
    }

    public static String sslContextVersion() {
        return VespaSslContextProvider.tlsEnabled() ? tlsContext.context().getProtocol() : "TLS";
    }
}

