/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.net.HostName;
import com.yahoo.protect.Process;
import com.yahoo.vespa.zookeeper.ExponentialBackoff;
import com.yahoo.vespa.zookeeper.ReconfigException;
import com.yahoo.vespa.zookeeper.Sleeper;
import com.yahoo.vespa.zookeeper.VespaZooKeeperAdmin;
import com.yahoo.vespa.zookeeper.VespaZooKeeperServer;
import com.yahoo.vespa.zookeeper.ZooKeeperRunner;
import com.yahoo.yolean.Exceptions;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Reconfigurer
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(Reconfigurer.class.getName());
    private static final Duration MIN_TIMEOUT = Duration.ofMinutes(3L);
    private static final Duration NODE_TIMEOUT = Duration.ofMinutes(1L);
    private final ExponentialBackoff backoff = new ExponentialBackoff(Duration.ofSeconds(1L), Duration.ofSeconds(10L));
    private final VespaZooKeeperAdmin vespaZooKeeperAdmin;
    private final Sleeper sleeper;
    private ZooKeeperRunner zooKeeperRunner;
    private ZookeeperServerConfig activeConfig;

    @Inject
    public Reconfigurer(VespaZooKeeperAdmin vespaZooKeeperAdmin) {
        this(vespaZooKeeperAdmin, new Sleeper());
    }

    Reconfigurer(VespaZooKeeperAdmin vespaZooKeeperAdmin, Sleeper sleeper) {
        this.vespaZooKeeperAdmin = Objects.requireNonNull(vespaZooKeeperAdmin);
        this.sleeper = Objects.requireNonNull(sleeper);
        log.log(Level.FINE, "Created ZooKeeperReconfigurer");
    }

    void startOrReconfigure(ZookeeperServerConfig newConfig, VespaZooKeeperServer server) {
        if (this.zooKeeperRunner == null) {
            this.zooKeeperRunner = this.startServer(newConfig, server);
        }
        if (this.shouldReconfigure(newConfig)) {
            this.reconfigure(newConfig, server);
        }
    }

    ZookeeperServerConfig activeConfig() {
        return this.activeConfig;
    }

    void shutdown() {
        if (this.zooKeeperRunner != null) {
            this.zooKeeperRunner.shutdown();
        }
    }

    private boolean shouldReconfigure(ZookeeperServerConfig newConfig) {
        if (!newConfig.dynamicReconfiguration()) {
            return false;
        }
        if (this.activeConfig == null) {
            return false;
        }
        return !newConfig.equals((Object)this.activeConfig());
    }

    private ZooKeeperRunner startServer(ZookeeperServerConfig zookeeperServerConfig, VespaZooKeeperServer server) {
        ZooKeeperRunner runner = new ZooKeeperRunner(zookeeperServerConfig, server);
        this.activeConfig = zookeeperServerConfig;
        return runner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconfigure(ZookeeperServerConfig newConfig, VespaZooKeeperServer server) {
        Instant reconfigTriggered = Instant.now();
        List<String> newServers = Reconfigurer.difference(Reconfigurer.servers(newConfig), Reconfigurer.servers(this.activeConfig));
        String leavingServers = String.join((CharSequence)",", Reconfigurer.difference(Reconfigurer.serverIds(this.activeConfig), Reconfigurer.serverIds(newConfig)));
        String joiningServers = String.join((CharSequence)",", newServers);
        leavingServers = leavingServers.isEmpty() ? null : leavingServers;
        joiningServers = joiningServers.isEmpty() ? null : joiningServers;
        log.log(Level.INFO, "Will reconfigure ZooKeeper cluster. Joining servers: " + joiningServers + ", leaving servers: " + leavingServers);
        String connectionSpec = Reconfigurer.localConnectionSpec(this.activeConfig);
        Instant now = Instant.now();
        Duration reconfigTimeout = Reconfigurer.reconfigTimeout(newServers.size());
        Instant end = now.plus(reconfigTimeout);
        int attempt = 1;
        while (now.isBefore(end)) {
            try {
                Instant reconfigStarted = Instant.now();
                this.vespaZooKeeperAdmin.reconfigure(connectionSpec, joiningServers, leavingServers);
                Instant reconfigEnded = Instant.now();
                log.log(Level.INFO, "Reconfiguration completed in " + Duration.between(reconfigTriggered, reconfigEnded) + ", after " + attempt + " attempt(s). ZooKeeper reconfig call took " + Duration.between(reconfigStarted, reconfigEnded));
                this.activeConfig = newConfig;
                return;
            }
            catch (ReconfigException e) {
                Duration delay = this.backoff.delay(attempt);
                log.log(Level.WARNING, "Reconfiguration attempt " + attempt + " failed. Retrying in " + delay + ", time left " + Duration.between(now, end) + ": " + Exceptions.toMessageString((Throwable)e));
                this.sleeper.sleep(delay);
            }
            finally {
                now = Instant.now();
            }
            ++attempt;
        }
        server.shutdown();
        Process.logAndDie((String)("Reconfiguration did not complete within timeout " + reconfigTimeout + ". Forcing shutdown"));
    }

    private static Duration reconfigTimeout(int joiningServers) {
        return Duration.ofMillis(Math.max((long)joiningServers * NODE_TIMEOUT.toMillis(), MIN_TIMEOUT.toMillis()));
    }

    private static String localConnectionSpec(ZookeeperServerConfig config) {
        return HostName.getLocalhost() + ":" + config.clientPort();
    }

    private static List<String> serverIds(ZookeeperServerConfig config) {
        return config.server().stream().map(ZookeeperServerConfig.Server::id).map(String::valueOf).collect(Collectors.toList());
    }

    private static List<String> servers(ZookeeperServerConfig config) {
        return config.server().stream().map(server -> server.id() + "=" + server.hostname() + ":" + server.quorumPort() + ":" + server.electionPort() + ";" + config.clientPort()).collect(Collectors.toList());
    }

    private static <T> List<T> difference(List<T> list1, List<T> list2) {
        ArrayList<T> copy = new ArrayList<T>(list1);
        copy.removeAll(list2);
        return copy;
    }
}

