/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.security.tls.TransportSecurityUtils;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.zookeeper.Configurator;
import com.yahoo.vespa.zookeeper.VespaZooKeeperServer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZooKeeperRunner
implements Runnable {
    private static final Logger log = Logger.getLogger(ZooKeeperRunner.class.getName());
    private static final Duration shutdownTimeout = Duration.ofSeconds(10L);
    private final ExecutorService executorService;
    private final ZookeeperServerConfig zookeeperServerConfig;
    private final VespaZooKeeperServer server;

    public ZooKeeperRunner(ZookeeperServerConfig zookeeperServerConfig, VespaZooKeeperServer server) {
        this.zookeeperServerConfig = zookeeperServerConfig;
        this.server = server;
        new Configurator(zookeeperServerConfig).writeConfigToDisk(TransportSecurityUtils.getOptions());
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory("zookeeper server"));
        this.executorService.submit(this);
    }

    void shutdown() {
        log.log(Level.INFO, "Triggering shutdown");
        this.executorService.shutdownNow();
        log.log(Level.INFO, "Shutdown triggered");
        try {
            if (!this.executorService.awaitTermination(shutdownTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                log.log(Level.WARNING, "Failed to shut down within " + shutdownTimeout);
            }
        }
        catch (InterruptedException e) {
            log.log(Level.INFO, "Interrupted waiting for executor to complete", e);
        }
    }

    @Override
    public void run() {
        Path path = Paths.get(Defaults.getDefaults().underVespaHome(this.zookeeperServerConfig.zooKeeperConfigFile()), new String[0]);
        Instant end = Instant.now().plus(Duration.ofMinutes(10L));
        while (true) {
            try {
                log.log(Level.INFO, "Starting ZooKeeper server with config file " + path.toFile().getAbsolutePath() + ". Trying to establish ZooKeeper quorum (members: " + Configurator.zookeeperServerHostnames(this.zookeeperServerConfig) + ")");
                this.startServer(path);
                return;
            }
            catch (RuntimeException e) {
                log.log(Level.INFO, "Starting ZooKeeper server failed, will retry", e);
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    log.log(Level.INFO, "Failed interrupting task", e);
                }
                if (Instant.now().isBefore(end) && !this.executorService.isShutdown()) continue;
                return;
            }
            break;
        }
    }

    private void startServer(Path path) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.server.start(path);
        }
        catch (Throwable e) {
            throw new RuntimeException("Starting ZooKeeper server failed", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

