/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import ai.vespa.validation.Validation;
import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.vespa.zookeeper.VespaQuorumPeer;
import com.yahoo.vespa.zookeeper.VespaZooKeeperAdminImpl;
import com.yahoo.vespa.zookeeper.ZooKeeperRunner;
import com.yahoo.vespa.zookeeper.server.VespaZooKeeperServer;
import java.nio.file.Path;
import java.time.Duration;

public final class VespaZooKeeperServerImpl
extends AbstractComponent
implements VespaZooKeeperServer {
    private final VespaQuorumPeer peer;
    private final ZooKeeperRunner runner;

    @Inject
    public VespaZooKeeperServerImpl(ZookeeperServerConfig zookeeperServerConfig) {
        Validation.require((!zookeeperServerConfig.dynamicReconfiguration() ? 1 : 0) != 0, (Object)(!zookeeperServerConfig.dynamicReconfiguration() ? 1 : 0), (String)"dynamicReconfiguration must be false");
        this.peer = new VespaQuorumPeer();
        this.runner = new ZooKeeperRunner(zookeeperServerConfig, (VespaZooKeeperServer)this);
        new VespaZooKeeperAdminImpl().createDummyNode(zookeeperServerConfig);
    }

    public void deconstruct() {
        this.runner.shutdown();
        super.deconstruct();
    }

    public void shutdown() {
        this.peer.shutdown(Duration.ofMinutes(1L));
    }

    public void start(Path configFilePath) {
        this.peer.start(configFilePath);
    }

    public boolean reconfigurable() {
        return false;
    }
}

