/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.vespa.zookeeper.ReconfigException;
import com.yahoo.vespa.zookeeper.VespaZooKeeperAdmin;
import com.yahoo.vespa.zookeeper.client.ZkClientConfigBuilder;
import com.yahoo.yolean.Exceptions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.admin.ZooKeeperAdmin;

public class VespaZooKeeperAdminImpl
implements VespaZooKeeperAdmin {
    private static final Logger log = Logger.getLogger(VespaZooKeeperAdminImpl.class.getName());

    public void reconfigure(String connectionSpec, String servers) throws ReconfigException {
        try (ZooKeeperAdmin zooKeeperAdmin = this.createAdmin(connectionSpec);){
            long fromConfig = -1L;
            log.log(Level.INFO, "Applying ZooKeeper config: " + servers);
            byte[] appliedConfig = zooKeeperAdmin.reconfigure(null, null, servers, fromConfig, null);
            log.log(Level.INFO, "Applied ZooKeeper config: " + new String(appliedConfig, StandardCharsets.UTF_8));
            ArrayList acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
            String node = zooKeeperAdmin.create("/reconfigure-dummy-node", new byte[0], (List)acl, CreateMode.EPHEMERAL_SEQUENTIAL);
            zooKeeperAdmin.delete(node, -1);
            log.log(Level.INFO, "Verified ZooKeeper config: " + new String(appliedConfig, StandardCharsets.UTF_8));
        }
        catch (KeeperException.ConnectionLossException | KeeperException.NewConfigNoQuorum | KeeperException.ReconfigInProgress e) {
            throw new ReconfigException(e);
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException(e);
        }
    }

    private ZooKeeperAdmin createAdmin(String connectionSpec) {
        return (ZooKeeperAdmin)Exceptions.uncheck(() -> new ZooKeeperAdmin(connectionSpec, (int)this.sessionTimeout().toMillis(), event -> log.log(Level.FINE, event.toString()), new ZkClientConfigBuilder().toConfig()));
    }

    /*
     * Exception decompiling
     */
    void createDummyNode(ZookeeperServerConfig zookeeperServerConfig) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK], 3[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

