/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import com.yahoo.protect.Process;
import com.yahoo.vespa.zookeeper.QuorumPeer;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.server.admin.AdminServer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;

class VespaQuorumPeer
extends QuorumPeerMain
implements QuorumPeer {
    private static final Logger log = Logger.getLogger(VespaQuorumPeer.class.getName());

    VespaQuorumPeer() {
    }

    public void start(Path path) {
        this.initializeAndRun(new String[]{path.toFile().getAbsolutePath()});
    }

    public void shutdown(Duration timeout) {
        if (this.quorumPeer != null) {
            log.log(Level.FINE, "Shutting down ZooKeeper server");
            try {
                this.quorumPeer.shutdown();
                this.quorumPeer.join(timeout.toMillis());
                if (this.quorumPeer.isAlive()) {
                    throw new IllegalStateException("Peer still alive after " + String.valueOf(timeout));
                }
            }
            catch (InterruptedException | RuntimeException e) {
                Process.logAndDie((String)"Failed to shut down ZooKeeper server properly, forcing shutdown", (Throwable)e);
            }
        }
    }

    protected void initializeAndRun(String[] args) {
        try {
            super.initializeAndRun(args);
        }
        catch (IOException | AdminServer.AdminServerException | QuorumPeerConfig.ConfigException e) {
            throw new RuntimeException("Exception when initializing or running ZooKeeper server", e);
        }
    }
}

