/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import ai.vespa.validation.Validation;
import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.vespa.zookeeper.QuorumPeer;
import com.yahoo.vespa.zookeeper.Reconfigurer;
import com.yahoo.vespa.zookeeper.VespaQuorumPeer;
import com.yahoo.vespa.zookeeper.server.VespaZooKeeperServer;
import java.nio.file.Path;
import java.time.Duration;

public final class ReconfigurableVespaZooKeeperServer
extends AbstractComponent
implements VespaZooKeeperServer {
    private QuorumPeer peer;

    @Inject
    public ReconfigurableVespaZooKeeperServer(Reconfigurer reconfigurer, ZookeeperServerConfig zookeeperServerConfig) {
        Validation.require((boolean)zookeeperServerConfig.dynamicReconfiguration(), (Object)zookeeperServerConfig.dynamicReconfiguration(), (String)"dynamicReconfiguration must be true");
        this.peer = reconfigurer.startOrReconfigure(zookeeperServerConfig, (VespaZooKeeperServer)this, () -> {
            this.peer = new VespaQuorumPeer();
            return this.peer;
        });
    }

    public void shutdown() {
        this.peer.shutdown(Duration.ofMinutes(1L));
    }

    public void start(Path configFilePath) {
        this.peer.start(configFilePath);
    }

    public boolean reconfigurable() {
        return true;
    }
}

