/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.transaction;

import com.yahoo.path.Path;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorCreateOperation;
import com.yahoo.vespa.curator.transaction.CuratorDeleteOperation;
import com.yahoo.vespa.curator.transaction.CuratorOperation;
import com.yahoo.vespa.curator.transaction.CuratorSetDataOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class CuratorOperations {
    public static CuratorOperation setData(String path, byte[] bytes) {
        return new CuratorSetDataOperation(path, bytes);
    }

    public static CuratorOperation create(String path, byte[] bytes) {
        return new CuratorCreateOperation(path, Optional.of(bytes));
    }

    public static CuratorOperation create(String path) {
        return new CuratorCreateOperation(path, Optional.empty());
    }

    public static CuratorOperation delete(String path) {
        return new CuratorDeleteOperation(path);
    }

    public static List<CuratorOperation> deleteAll(String path, Curator curator) {
        if (!curator.exists(Path.fromString((String)path))) {
            return Collections.emptyList();
        }
        ArrayList<CuratorOperation> operations = new ArrayList<CuratorOperation>();
        CuratorOperations.deleteRecursively(Path.fromString((String)path), operations, curator);
        return operations;
    }

    private static void deleteRecursively(Path path, List<CuratorOperation> operations, Curator curator) {
        for (String childName : curator.getChildren(path)) {
            CuratorOperations.deleteRecursively(path.append(childName), operations, curator);
        }
        operations.add(CuratorOperations.delete(path.getAbsolute()));
    }
}

