/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.stats;

import com.yahoo.vespa.curator.stats.LockAttempt;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class RecordedLockAttempts {
    private static final int MAX_TOP_LEVEL_LOCK_ATTEMPTS = 100;
    private final String recordId;
    private final Instant startInstant;
    private volatile Instant endInstant = null;
    private final ConcurrentLinkedQueue<LockAttempt> lockAttempts = new ConcurrentLinkedQueue();

    static RecordedLockAttempts startRecording(String recordId) {
        return new RecordedLockAttempts(recordId);
    }

    private RecordedLockAttempts(String recordId) {
        this.recordId = recordId;
        this.startInstant = Instant.now();
    }

    void addTopLevelLockAttempt(LockAttempt lockAttempt) {
        if (this.lockAttempts.size() < 100) {
            this.lockAttempts.add(lockAttempt);
        }
    }

    void stopRecording() {
        this.endInstant = Instant.now();
    }

    public String recordId() {
        return this.recordId;
    }

    public Instant startInstant() {
        return this.startInstant;
    }

    public Instant endInstant() {
        return this.endInstant == null ? Instant.now() : this.endInstant;
    }

    public Duration duration() {
        return Duration.between(this.startInstant, this.endInstant());
    }

    public List<LockAttempt> lockAttempts() {
        return List.copyOf(this.lockAttempts);
    }
}

