/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.stats;

import com.yahoo.vespa.curator.stats.LatencyStats;
import com.yahoo.vespa.curator.stats.LockMetrics;
import com.yahoo.vespa.curator.stats.ThreadLockStats;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class LockAttempt {
    private final ThreadLockStats threadLockStats;
    private final String lockPath;
    private final Instant callAcquireInstant;
    private final Duration timeout;
    private final boolean reentry;
    private final LockMetrics lockMetrics;
    private final List<LockAttempt> nestedLockAttempts = new ArrayList<LockAttempt>();
    private final LatencyStats.ActiveInterval activeAcquireInterval;
    private Optional<LatencyStats.ActiveInterval> activeLockedInterval = Optional.empty();
    private volatile Optional<Instant> lockAcquiredInstant = Optional.empty();
    private volatile Optional<Instant> terminalStateInstant = Optional.empty();
    private volatile Optional<String> stackTrace = Optional.empty();
    private volatile LockState lockState = LockState.ACQUIRING;

    public static LockAttempt invokingAcquire(ThreadLockStats threadLockStats, String lockPath, Duration timeout, LockMetrics lockMetrics, boolean reentry) {
        return new LockAttempt(threadLockStats, lockPath, timeout, Instant.now(), lockMetrics, reentry);
    }

    private LockAttempt(ThreadLockStats threadLockStats, String lockPath, Duration timeout, Instant callAcquireInstant, LockMetrics lockMetrics, boolean reentry) {
        this.threadLockStats = threadLockStats;
        this.lockPath = lockPath;
        this.callAcquireInstant = callAcquireInstant;
        this.timeout = timeout;
        this.lockMetrics = lockMetrics;
        this.reentry = reentry;
        this.activeAcquireInterval = lockMetrics.acquireInvoked(reentry);
    }

    public String getThreadName() {
        return this.threadLockStats.getThreadName();
    }

    public String getLockPath() {
        return this.lockPath;
    }

    public Instant getTimeAcquiredWasInvoked() {
        return this.callAcquireInstant;
    }

    public Duration getAcquireTimeout() {
        return this.timeout;
    }

    public boolean isReentry() {
        return this.reentry;
    }

    public LockState getLockState() {
        return this.lockState;
    }

    public Optional<Instant> getTimeLockWasAcquired() {
        return this.lockAcquiredInstant;
    }

    public boolean isAcquiring() {
        return this.lockAcquiredInstant.isEmpty();
    }

    public Instant getTimeAcquireEndedOrNow() {
        return this.lockAcquiredInstant.orElseGet(() -> this.getTimeTerminalStateWasReached().orElseGet(Instant::now));
    }

    public Optional<Instant> getTimeTerminalStateWasReached() {
        return this.terminalStateInstant;
    }

    public Optional<String> getStackTrace() {
        return this.stackTrace;
    }

    public List<LockAttempt> getNestedLockAttempts() {
        return List.copyOf(this.nestedLockAttempts);
    }

    public Duration getDurationOfAcquire() {
        return Duration.between(this.callAcquireInstant, this.getTimeAcquireEndedOrNow());
    }

    public Duration getDurationWithLock() {
        return this.lockAcquiredInstant.map(start -> Duration.between(start, this.terminalStateInstant.orElseGet(Instant::now))).orElse(Duration.ZERO);
    }

    public Duration getDuration() {
        return Duration.between(this.callAcquireInstant, this.terminalStateInstant.orElseGet(Instant::now));
    }

    public Duration getStableTotalDuration() {
        return this.terminalStateInstant.map(instant -> Duration.between(this.callAcquireInstant, instant)).orElse(Duration.ZERO);
    }

    public void fillStackTrace() {
        this.stackTrace = Optional.of(this.threadLockStats.getStackTrace());
    }

    void addNestedLockAttempt(LockAttempt nestedLockAttempt) {
        this.nestedLockAttempts.add(nestedLockAttempt);
    }

    void acquireFailed() {
        this.setTerminalState(LockState.ACQUIRE_FAILED);
        this.lockMetrics.acquireFailed(this.reentry, this.activeAcquireInterval);
    }

    void timedOut() {
        this.setTerminalState(LockState.TIMED_OUT);
        this.lockMetrics.acquireTimedOut(this.reentry, this.activeAcquireInterval);
    }

    void lockAcquired() {
        this.lockState = LockState.ACQUIRED;
        this.lockAcquiredInstant = Optional.of(Instant.now());
        this.activeLockedInterval = Optional.of(this.lockMetrics.lockAcquired(this.reentry, this.activeAcquireInterval));
    }

    void preRelease() {
        this.lockMetrics.preRelease(this.reentry, this.activeLockedInterval.orElseThrow());
    }

    void postRelease() {
        this.setTerminalState(LockState.RELEASED);
    }

    void releaseFailed() {
        this.setTerminalState(LockState.RELEASED_WITH_ERROR);
        this.lockMetrics.releaseFailed(this.reentry);
    }

    void setTerminalState(LockState terminalState) {
        this.setTerminalState(terminalState, Instant.now());
    }

    void setTerminalState(LockState terminalState, Instant instant) {
        this.lockState = terminalState;
        this.terminalStateInstant = Optional.of(instant);
    }

    public static enum LockState {
        ACQUIRING(false),
        ACQUIRE_FAILED(true),
        TIMED_OUT(true),
        ACQUIRED(false),
        RELEASED(true),
        RELEASED_WITH_ERROR(true);

        private final boolean terminal;

        private LockState(boolean terminal) {
            this.terminal = terminal;
        }

        public boolean isTerminal() {
            return this.terminal;
        }
    }
}

