/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.yahoo.transaction.Mutex;
import com.yahoo.vespa.curator.Lock;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiplePathsLock
implements Mutex {
    private static final Logger log = Logger.getLogger(MultiplePathsLock.class.getName());
    private final List<Lock> locks;

    public MultiplePathsLock(Lock ... locks) {
        this.locks = List.of(locks);
    }

    public void close() {
        this.close(0);
    }

    private void close(int i) {
        if (i < this.locks.size()) {
            try (Lock lock = this.locks.get(i);){
                this.close(i + 1);
                log.log(Level.FINE, "Closing lock " + lock.lockPath());
            }
        }
    }
}

