/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.yahoo.concurrent.UncheckedTimeoutException;
import com.yahoo.transaction.Mutex;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.stats.LockStats;
import com.yahoo.vespa.curator.stats.ThreadLockStats;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.locks.InterProcessLock;

public class Lock
implements Mutex {
    private final InterProcessLock mutex;
    private final String lockPath;

    public Lock(String lockPath, Curator curator) {
        this(lockPath, curator.createMutex(lockPath));
    }

    public Lock(String lockPath, InterProcessLock mutex) {
        this.lockPath = lockPath;
        this.mutex = mutex;
    }

    public void acquire(Duration timeout) throws UncheckedTimeoutException {
        boolean acquired;
        ThreadLockStats threadLockStats = LockStats.getForCurrentThread();
        threadLockStats.invokingAcquire(this.lockPath, timeout);
        try {
            acquired = this.mutex.acquire(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            threadLockStats.acquireFailed();
            throw new RuntimeException("Exception acquiring lock '" + this.lockPath + "'", e);
        }
        if (!acquired) {
            threadLockStats.acquireTimedOut();
            throw new UncheckedTimeoutException("Timed out after waiting " + timeout + " to acquire lock '" + this.lockPath + "'");
        }
        threadLockStats.lockAcquired();
    }

    public void close() {
        ThreadLockStats threadLockStats = LockStats.getForCurrentThread();
        threadLockStats.preRelease(this.lockPath);
        try {
            this.mutex.release();
            threadLockStats.postRelease(this.lockPath);
        }
        catch (Exception e) {
            threadLockStats.releaseFailed(this.lockPath);
            throw new RuntimeException("Exception releasing lock '" + this.lockPath + "'", e);
        }
    }

    protected String lockPath() {
        return this.lockPath;
    }

    public String toString() {
        return "Lock{" + this.lockPath + "}";
    }
}

