/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.yahoo.path.Path;
import com.yahoo.vespa.curator.CompletionTimeoutException;
import com.yahoo.vespa.curator.Curator;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class CuratorCompletionWaiter
implements Curator.CompletionWaiter {
    private static final Logger log = Logger.getLogger(CuratorCompletionWaiter.class.getName());
    private final Curator curator;
    private final String barrierPath;
    private final String myId;
    private final Clock clock;
    private final Duration waitForAll;

    CuratorCompletionWaiter(Curator curator, String barrierPath, String myId, Clock clock, Duration waitForAll) {
        this.myId = barrierPath + "/" + myId;
        this.curator = curator;
        this.barrierPath = barrierPath;
        this.clock = clock;
        this.waitForAll = waitForAll;
    }

    @Override
    public void awaitCompletion(Duration timeout) {
        List<String> respondents;
        try {
            log.log(Level.FINE, () -> "Synchronizing on barrier " + this.barrierPath);
            respondents = this.awaitInternal(timeout);
            log.log(Level.FINE, () -> "Done synchronizing on barrier " + this.barrierPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (respondents.size() < this.barrierMemberCount()) {
            throw new CompletionTimeoutException("Timed out waiting for config servers to complete operation (waited for barrier " + this.barrierPath + ").Got response from " + respondents + ", but need response from at least " + this.barrierMemberCount() + " server(s). Timeout passed as argument was " + timeout.toMillis() + " ms");
        }
    }

    private List<String> awaitInternal(Duration timeout) throws Exception {
        Instant startTime = this.clock.instant();
        Instant endTime = startTime.plus(timeout);
        Instant gotQuorumTime = Instant.EPOCH;
        ArrayList<String> respondents = new ArrayList<String>();
        do {
            respondents.clear();
            respondents.addAll((Collection)this.curator.framework().getChildren().forPath(this.barrierPath));
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, respondents.size() + "/" + this.curator.zooKeeperEnsembleCount() + " responded: " + respondents + ", all participants: " + this.curator.zooKeeperEnsembleConnectionSpec());
            }
            if (respondents.size() == this.curator.zooKeeperEnsembleCount()) {
                this.logBarrierCompleted(respondents, startTime);
                break;
            }
            if (respondents.size() >= this.barrierMemberCount()) {
                if (gotQuorumTime.isBefore(startTime)) {
                    gotQuorumTime = this.clock.instant();
                }
                if (Duration.between(this.clock.instant(), gotQuorumTime.plus(this.waitForAll)).isNegative()) {
                    this.logBarrierCompleted(respondents, startTime);
                    break;
                }
            }
            Thread.sleep(100L);
        } while (this.clock.instant().isBefore(endTime));
        return respondents;
    }

    private void logBarrierCompleted(List<String> respondents, Instant startTime) {
        Duration duration = Duration.between(startTime, Instant.now());
        Level level = duration.minus(Duration.ofSeconds(5L)).isNegative() ? Level.FINE : Level.INFO;
        log.log(level, () -> this.barrierCompletedMessage(respondents, duration));
    }

    private String barrierCompletedMessage(List<String> respondents, Duration duration) {
        return this.barrierPath + " completed in " + duration.toString() + ", " + respondents.size() + "/" + this.curator.zooKeeperEnsembleCount() + " responded: " + respondents;
    }

    @Override
    public void notifyCompletion() {
        try {
            this.notifyInternal();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void notifyInternal() throws Exception {
        this.curator.framework().create().forPath(this.myId);
    }

    public String toString() {
        return "'" + this.barrierPath + "', " + this.barrierMemberCount() + " members";
    }

    public static Curator.CompletionWaiter create(Curator curator, Path barrierPath, String id, Duration waitForAll) {
        return new CuratorCompletionWaiter(curator, barrierPath.getAbsolute(), id, Clock.systemUTC(), waitForAll);
    }

    public static Curator.CompletionWaiter createAndInitialize(Curator curator, Path parentPath, String waiterNode, String id, Duration waitForAll) {
        String debugMessage;
        Path waiterPath = parentPath.append(waiterNode);
        String string = debugMessage = log.isLoggable(Level.FINE) ? "Recreating ZK path " + waiterPath : null;
        if (debugMessage != null) {
            log.fine(debugMessage);
        }
        curator.delete(waiterPath);
        curator.createAtomically(waiterPath);
        if (debugMessage != null) {
            log.fine(debugMessage + ": Done");
        }
        return new CuratorCompletionWaiter(curator, waiterPath.getAbsolute(), id, Clock.systemUTC(), waitForAll);
    }

    private int barrierMemberCount() {
        return this.curator.zooKeeperEnsembleCount() / 2 + 1;
    }
}

