/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.transaction;

import com.yahoo.path.Path;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorOperation;
import com.yahoo.vespa.curator.transaction.TransactionChanges;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;

class CuratorSetDataOperation
implements CuratorOperation {
    private final String path;
    private final byte[] data;

    public CuratorSetDataOperation(String path, byte[] data) {
        this.path = path;
        this.data = data;
    }

    @Override
    public void check(Curator curator, TransactionChanges changes) {
        if (!curator.exists(Path.fromString((String)this.path)) && !changes.create(this.path)) {
            throw new IllegalStateException("Cannot perform " + this + ": Path does not exist");
        }
    }

    @Override
    public CuratorTransaction and(CuratorTransaction transaction) throws Exception {
        return ((CuratorTransactionBridge)transaction.setData().forPath(this.path, this.data)).and();
    }

    public String toString() {
        return "SET " + this.path;
    }
}

