/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.mock;

import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.yahoo.collections.Pair;
import com.yahoo.concurrent.Lock;
import com.yahoo.concurrent.Locks;
import com.yahoo.path.Path;
import com.yahoo.vespa.curator.CompletionTimeoutException;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.mock.MemoryFileSystem;
import com.yahoo.vespa.curator.recipes.CuratorLockException;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.WatcherRemoveCuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLCreateModeBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLCreateModePathAndBytesable;
import org.apache.curator.framework.api.ACLCreateModeStatBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLPathAndBytesable;
import org.apache.curator.framework.api.ACLableExistBuilderMain;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.BackgroundVersionable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.CreateBackgroundModeStatACLable;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.curator.framework.api.CreateBuilder2;
import org.apache.curator.framework.api.CreateBuilderMain;
import org.apache.curator.framework.api.CreateProtectACLCreateModePathAndBytesable;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.api.DeleteBuilder;
import org.apache.curator.framework.api.DeleteBuilderMain;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.api.ExistsBuilder;
import org.apache.curator.framework.api.GetACLBuilder;
import org.apache.curator.framework.api.GetChildrenBuilder;
import org.apache.curator.framework.api.GetConfigBuilder;
import org.apache.curator.framework.api.GetDataBuilder;
import org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.ProtectACLCreateModeStatPathAndBytesable;
import org.apache.curator.framework.api.ReconfigBuilder;
import org.apache.curator.framework.api.RemoveWatchesBuilder;
import org.apache.curator.framework.api.SetACLBuilder;
import org.apache.curator.framework.api.SetDataBackgroundVersionable;
import org.apache.curator.framework.api.SetDataBuilder;
import org.apache.curator.framework.api.SyncBuilder;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.api.VersionPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.api.Watchable;
import org.apache.curator.framework.api.WatchesBuilder;
import org.apache.curator.framework.api.transaction.CuratorMultiTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.curator.framework.api.transaction.TransactionCheckBuilder;
import org.apache.curator.framework.api.transaction.TransactionCreateBuilder;
import org.apache.curator.framework.api.transaction.TransactionCreateBuilder2;
import org.apache.curator.framework.api.transaction.TransactionDeleteBuilder;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.curator.framework.api.transaction.TransactionSetDataBuilder;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.recipes.atomic.AtomicStats;
import org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreMutex;
import org.apache.curator.framework.schema.SchemaSet;
import org.apache.curator.framework.state.ConnectionStateErrorPolicy;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryForever;
import org.apache.curator.utils.EnsurePath;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;

public class MockCuratorFramework
implements CuratorFramework {
    private final boolean shouldTimeoutOnEnter;
    private final boolean stableOrdering;
    private final Locks<String> locks = new Locks(Long.MAX_VALUE, TimeUnit.DAYS);
    private final MemoryFileSystem fileSystem = new MemoryFileSystem();
    private final Map<String, MockAtomicCounter> atomicCounters = new ConcurrentHashMap<String, MockAtomicCounter>();
    private final ListenerMap listeners = new ListenerMap();
    private CuratorFrameworkState curatorState = CuratorFrameworkState.LATENT;
    private int monotonicallyIncreasingNumber = 0;

    public MockCuratorFramework(boolean stableOrdering, boolean shouldTimeoutOnEnter) {
        this.stableOrdering = stableOrdering;
        this.shouldTimeoutOnEnter = shouldTimeoutOnEnter;
    }

    public Map<String, MockAtomicCounter> atomicCounters() {
        return Collections.unmodifiableMap(this.atomicCounters);
    }

    public MemoryFileSystem fileSystem() {
        return this.fileSystem;
    }

    public void start() {
        this.curatorState = CuratorFrameworkState.STARTED;
    }

    public void close() {
        this.curatorState = CuratorFrameworkState.STOPPED;
    }

    public CuratorFrameworkState getState() {
        return this.curatorState;
    }

    @Deprecated
    public boolean isStarted() {
        return this.curatorState == CuratorFrameworkState.STARTED;
    }

    public CreateBuilder create() {
        return new MockCreateBuilder();
    }

    public DeleteBuilder delete() {
        return new MockDeleteBuilder();
    }

    public ExistsBuilder checkExists() {
        return new MockExistsBuilder();
    }

    public GetDataBuilder getData() {
        return new MockGetDataBuilder();
    }

    public SetDataBuilder setData() {
        return new MockSetDataBuilder();
    }

    public GetChildrenBuilder getChildren() {
        return new MockGetChildrenBuilder();
    }

    public GetACLBuilder getACL() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public SetACLBuilder setACL() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public ReconfigBuilder reconfig() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public GetConfigBuilder getConfig() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public CuratorTransaction inTransaction() {
        return new MockCuratorTransactionFinal();
    }

    public CuratorMultiTransaction transaction() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public TransactionOp transactionOp() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public RemoveWatchesBuilder watches() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public WatchesBuilder watchers() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public WatcherRemoveCuratorFramework newWatcherRemoveCuratorFramework() {
        class MockWatcherRemoveCuratorFramework
        extends MockCuratorFramework
        implements WatcherRemoveCuratorFramework {
            public MockWatcherRemoveCuratorFramework(boolean stableOrdering, boolean shouldTimeoutOnEnter) {
                super(stableOrdering, shouldTimeoutOnEnter);
            }

            public void removeWatchers() {
            }
        }
        return new MockWatcherRemoveCuratorFramework(true, false);
    }

    public ConnectionStateErrorPolicy getConnectionStateErrorPolicy() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public QuorumVerifier getCurrentConfig() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public SchemaSet getSchemaSet() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public CompletableFuture<Void> postSafeNotify(Object monitorHolder) {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public CompletableFuture<Void> runSafe(Runnable runnable) {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    @Deprecated
    public void sync(String path, Object backgroundContextObject) {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public void createContainers(String s) {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public Listenable<ConnectionStateListener> getConnectionStateListenable() {
        return new MockListenable<ConnectionStateListener>();
    }

    public Listenable<CuratorListener> getCuratorListenable() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public Listenable<UnhandledErrorListener> getUnhandledErrorListenable() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    @Deprecated
    public CuratorFramework nonNamespaceView() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public CuratorFramework usingNamespace(String newNamespace) {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public String getNamespace() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public CuratorZookeeperClient getZookeeperClient() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    @Deprecated
    public EnsurePath newNamespaceAwareEnsurePath(String path) {
        return new EnsurePath(path);
    }

    public void clearWatcherReferences(Watcher watcher) {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public boolean blockUntilConnected(int i, TimeUnit timeUnit) {
        return true;
    }

    public void blockUntilConnected() {
    }

    public SyncBuilder sync() {
        throw new UnsupportedOperationException("Not implemented in MockCurator");
    }

    public InterProcessLock createMutex(String path) {
        return new MockLock(path);
    }

    public MockAtomicCounter createAtomicCounter(String path) {
        return this.atomicCounters.computeIfAbsent(path, k -> new MockAtomicCounter(path));
    }

    public Curator.CompletionWaiter createCompletionWaiter() {
        return new MockCompletionWaiter();
    }

    public Curator.DirectoryCache createDirectoryCache(String path) {
        return new MockDirectoryCache(Path.fromString((String)path));
    }

    public Curator.FileCache createFileCache(String path) {
        return new MockFileCache(Path.fromString((String)path));
    }

    private String createNode(String pathString, byte[] content, boolean createParents, CreateMode createMode, MemoryFileSystem.Node root, Listeners listeners) throws KeeperException.NodeExistsException, KeeperException.NoNodeException {
        MockCuratorFramework.validatePath(pathString);
        Path path = Path.fromString((String)pathString);
        if (path.isRoot()) {
            return "/";
        }
        MemoryFileSystem.Node parent = root.getNode(Paths.get(path.getParentPath().toString(), new String[0]), createParents);
        String name = this.nodeName(path.getName(), createMode);
        if (parent == null) {
            throw new KeeperException.NoNodeException(path.getParentPath().toString());
        }
        if (parent.children().containsKey(path.getName())) {
            throw new KeeperException.NodeExistsException(path.toString());
        }
        parent.add(name).setContent(content);
        String nodePath = "/" + path.getParentPath().toString() + "/" + name;
        listeners.notify(Path.fromString((String)nodePath), content, PathChildrenCacheEvent.Type.CHILD_ADDED);
        return nodePath;
    }

    private void deleteNode(String pathString, boolean deleteChildren, MemoryFileSystem.Node root, Listeners listeners) throws KeeperException.NoNodeException, KeeperException.NotEmptyException {
        MockCuratorFramework.validatePath(pathString);
        Path path = Path.fromString((String)pathString);
        MemoryFileSystem.Node parent = root.getNode(Paths.get(path.getParentPath().toString(), new String[0]), false);
        if (parent == null) {
            throw new KeeperException.NoNodeException(path.toString());
        }
        MemoryFileSystem.Node node = parent.children().get(path.getName());
        if (node == null) {
            throw new KeeperException.NoNodeException(path.getName() + " under " + parent);
        }
        if (!node.children().isEmpty() && !deleteChildren) {
            throw new KeeperException.NotEmptyException(path.toString());
        }
        parent.remove(path.getName());
        listeners.notify(path, new byte[0], PathChildrenCacheEvent.Type.CHILD_REMOVED);
    }

    private byte[] getData(String pathString, MemoryFileSystem.Node root) throws KeeperException.NoNodeException {
        MockCuratorFramework.validatePath(pathString);
        return this.getNode(pathString, root).getContent();
    }

    private void setData(String pathString, byte[] content, MemoryFileSystem.Node root, Listeners listeners) throws KeeperException.NoNodeException {
        MockCuratorFramework.validatePath(pathString);
        this.getNode(pathString, root).setContent(content);
        listeners.notify(Path.fromString((String)pathString), content, PathChildrenCacheEvent.Type.CHILD_UPDATED);
    }

    private List<String> getChildren(String path, MemoryFileSystem.Node root) throws KeeperException.NoNodeException {
        MockCuratorFramework.validatePath(path);
        MemoryFileSystem.Node node = root.getNode(Paths.get(path, new String[0]), false);
        if (node == null) {
            throw new KeeperException.NoNodeException(path);
        }
        ArrayList<String> children = new ArrayList<String>(node.children().keySet());
        if (!this.stableOrdering) {
            Collections.shuffle(children);
        }
        return children;
    }

    private MemoryFileSystem.Node getNode(String pathString, MemoryFileSystem.Node root) throws KeeperException.NoNodeException {
        MockCuratorFramework.validatePath(pathString);
        Path path = Path.fromString((String)pathString);
        MemoryFileSystem.Node parent = root.getNode(Paths.get(path.getParentPath().toString(), new String[0]), false);
        if (parent == null) {
            throw new KeeperException.NoNodeException(path.toString());
        }
        MemoryFileSystem.Node node = parent.children().get(path.getName());
        if (node == null) {
            throw new KeeperException.NoNodeException(path.toString());
        }
        return node;
    }

    private String nodeName(String baseName, CreateMode createMode) {
        switch (createMode) {
            case PERSISTENT: 
            case EPHEMERAL: {
                return baseName;
            }
            case PERSISTENT_SEQUENTIAL: 
            case EPHEMERAL_SEQUENTIAL: {
                return baseName + this.monotonicallyIncreasingNumber++;
            }
        }
        throw new UnsupportedOperationException(createMode + " support not implemented in MockCurator");
    }

    public static String validatePath(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Path length must be > 0");
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path must start with / character");
        }
        if (path.length() == 1) {
            return path;
        }
        if (path.charAt(path.length() - 1) == '/') {
            throw new IllegalArgumentException("Path must not end with / character");
        }
        String reason = null;
        int lastc = 47;
        char[] chars = path.toCharArray();
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\u0000') {
                reason = "null character not allowed @" + i;
                break;
            }
            if (c == '/' && lastc == 47) {
                reason = "empty node name specified @" + i;
                break;
            }
            if (c == '.' && lastc == 46) {
                if (chars[i - 2] == '/' && (i + 1 == chars.length || chars[i + 1] == '/')) {
                    reason = "relative paths not allowed @" + i;
                    break;
                }
            } else if (c == '.') {
                if (chars[i - 1] == '/' && (i + 1 == chars.length || chars[i + 1] == '/')) {
                    reason = "relative paths not allowed @" + i;
                    break;
                }
            } else if (c > '\u0000' && c < '\u001f' || c > '\u007f' && c < '\u009f' || c > '\ud800' && c < '\uf8ff' || c > '\ufff0' && c < '\uffff') {
                reason = "invalid character @" + i;
                break;
            }
            lastc = chars[i];
        }
        if (reason != null) {
            throw new IllegalArgumentException("Invalid path string \"" + path + "\" caused by " + reason);
        }
        return path;
    }

    private class MockCuratorTransactionFinal
    implements CuratorTransactionFinal {
        private MemoryFileSystem.Node newRoot;
        private boolean committed = false;
        private final DelayedListener delayedListener = new DelayedListener();

        public MockCuratorTransactionFinal() {
            this.newRoot = MockCuratorFramework.this.fileSystem.root().clone();
        }

        public Collection<CuratorTransactionResult> commit() throws Exception {
            MockCuratorFramework.this.fileSystem.replaceRoot(this.newRoot);
            this.committed = true;
            this.delayedListener.commit();
            return null;
        }

        public TransactionCreateBuilder create() {
            this.ensureNotCommitted();
            return new MockTransactionCreateBuilder();
        }

        public TransactionDeleteBuilder delete() {
            this.ensureNotCommitted();
            return new MockTransactionDeleteBuilder();
        }

        public TransactionSetDataBuilder setData() {
            this.ensureNotCommitted();
            return new MockTransactionSetDataBuilder();
        }

        public TransactionCheckBuilder check() {
            this.ensureNotCommitted();
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        private void ensureNotCommitted() {
            if (this.committed) {
                throw new IllegalStateException("transaction already committed");
            }
        }

        private class DelayedListener
        extends Listeners {
            private final List<Pair<Path, PathChildrenCacheEvent>> events = new ArrayList<Pair<Path, PathChildrenCacheEvent>>();

            private DelayedListener() {
            }

            @Override
            public void notify(Path path, PathChildrenCacheEvent event) {
                this.events.add((Pair<Path, PathChildrenCacheEvent>)new Pair((Object)path, (Object)event));
            }

            public void commit() {
                for (Pair<Path, PathChildrenCacheEvent> event : this.events) {
                    MockCuratorFramework.this.listeners.notify((Path)event.getFirst(), (PathChildrenCacheEvent)event.getSecond());
                }
            }
        }

        private class MockCuratorTransactionBridge
        implements CuratorTransactionBridge {
            private MockCuratorTransactionBridge() {
            }

            public CuratorTransactionFinal and() {
                return MockCuratorTransactionFinal.this;
            }
        }

        private class MockTransactionSetDataBuilder
        implements TransactionSetDataBuilder {
            private MockTransactionSetDataBuilder() {
            }

            public VersionPathAndBytesable<CuratorTransactionBridge> compressed() {
                throw new UnsupportedOperationException("Not implemented in MockCurator");
            }

            public PathAndBytesable<CuratorTransactionBridge> withVersion(int i) {
                throw new UnsupportedOperationException("Not implemented in MockCurator");
            }

            public CuratorTransactionBridge forPath(String s, byte[] bytes) throws Exception {
                MockCuratorFramework.this.setData(s, bytes, MockCuratorTransactionFinal.this.newRoot, MockCuratorTransactionFinal.this.delayedListener);
                return new MockCuratorTransactionBridge();
            }

            public CuratorTransactionBridge forPath(String s) throws Exception {
                MockCuratorFramework.this.setData(s, new byte[0], MockCuratorTransactionFinal.this.newRoot, MockCuratorTransactionFinal.this.delayedListener);
                return new MockCuratorTransactionBridge();
            }
        }

        private class MockTransactionDeleteBuilder
        implements TransactionDeleteBuilder {
            private MockTransactionDeleteBuilder() {
            }

            public Pathable<CuratorTransactionBridge> withVersion(int i) {
                throw new UnsupportedOperationException("Not implemented in MockCurator");
            }

            public CuratorTransactionBridge forPath(String path) throws Exception {
                MockCuratorFramework.this.deleteNode(path, false, MockCuratorTransactionFinal.this.newRoot, MockCuratorTransactionFinal.this.delayedListener);
                return new MockCuratorTransactionBridge();
            }
        }

        private class MockTransactionCreateBuilder
        implements TransactionCreateBuilder {
            private CreateMode createMode = CreateMode.PERSISTENT;

            private MockTransactionCreateBuilder() {
            }

            public ACLCreateModePathAndBytesable<CuratorTransactionBridge> compressed() {
                throw new UnsupportedOperationException("Not implemented in MockCurator");
            }

            public ACLPathAndBytesable<CuratorTransactionBridge> withMode(CreateMode createMode) {
                this.createMode = createMode;
                return this;
            }

            public CuratorTransactionBridge forPath(String s, byte[] bytes) throws Exception {
                MockCuratorFramework.this.createNode(s, bytes, false, this.createMode, MockCuratorTransactionFinal.this.newRoot, MockCuratorTransactionFinal.this.delayedListener);
                return new MockCuratorTransactionBridge();
            }

            public CuratorTransactionBridge forPath(String s) throws Exception {
                MockCuratorFramework.this.createNode(s, new byte[0], false, this.createMode, MockCuratorTransactionFinal.this.newRoot, MockCuratorTransactionFinal.this.delayedListener);
                return new MockCuratorTransactionBridge();
            }

            public TransactionCreateBuilder2 withTtl(long l) {
                return this;
            }

            public Object withACL(List list, boolean b) {
                return this;
            }

            public Object withACL(List list) {
                return this;
            }
        }
    }

    private static class MockListenable<T>
    implements Listenable<T> {
        private MockListenable() {
        }

        public void addListener(T t) {
        }

        public void addListener(T t, Executor executor) {
        }

        public void removeListener(T t) {
        }
    }

    private class MockSetDataBuilder
    implements SetDataBuilder {
        private MockSetDataBuilder() {
        }

        public SetDataBackgroundVersionable compressed() {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public BackgroundPathAndBytesable<Stat> withVersion(int i) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public Stat forPath(String path, byte[] bytes) throws Exception {
            MockCuratorFramework.this.setData(path, bytes, MockCuratorFramework.this.fileSystem.root(), MockCuratorFramework.this.listeners);
            return null;
        }

        public Stat forPath(String s) throws Exception {
            return null;
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground() {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground(Object o) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback backgroundCallback) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback backgroundCallback, Object o) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback backgroundCallback, Object o, Executor executor) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public SetDataBuilder idempotent() {
            return this;
        }
    }

    private class MockGetDataBuilder
    extends MockBackgroundPathableBuilder<byte[]>
    implements GetDataBuilder {
        private MockGetDataBuilder() {
        }

        public GetDataWatchBackgroundStatable decompressed() {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        @Override
        public byte[] forPath(String path) throws Exception {
            return MockCuratorFramework.this.getData(path, MockCuratorFramework.this.fileSystem.root());
        }

        @Override
        public ErrorListenerPathable<byte[]> inBackground() {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        @Override
        public ErrorListenerPathable<byte[]> inBackground(Object o) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        @Override
        public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback backgroundCallback) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        @Override
        public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback backgroundCallback, Object o) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        @Override
        public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        @Override
        public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback backgroundCallback, Object o, Executor executor) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public WatchPathable<byte[]> storingStatIn(Stat stat) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }
    }

    private class MockDeleteBuilder
    extends MockBackgroundPathableBuilder<Void>
    implements DeleteBuilder {
        private boolean deleteChildren = false;

        private MockDeleteBuilder() {
        }

        public BackgroundVersionable deletingChildrenIfNeeded() {
            this.deleteChildren = true;
            return this;
        }

        public ChildrenDeletable guaranteed() {
            return this;
        }

        public BackgroundPathable<Void> withVersion(int i) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        @Override
        public Void forPath(String pathString) throws Exception {
            MockCuratorFramework.this.deleteNode(pathString, this.deleteChildren, MockCuratorFramework.this.fileSystem.root(), MockCuratorFramework.this.listeners);
            return null;
        }

        public DeleteBuilderMain quietly() {
            return this;
        }

        public DeleteBuilderMain idempotent() {
            return this;
        }
    }

    private class MockExistsBuilder
    extends MockBackgroundPathableBuilder<Stat>
    implements ExistsBuilder {
        private MockExistsBuilder() {
        }

        @Override
        public Stat forPath(String path) throws Exception {
            try {
                MemoryFileSystem.Node node = MockCuratorFramework.this.getNode(path, MockCuratorFramework.this.fileSystem.root());
                Stat stat = new Stat();
                stat.setVersion(node.version());
                return stat;
            }
            catch (KeeperException.NoNodeException e) {
                return null;
            }
        }

        public ACLableExistBuilderMain creatingParentsIfNeeded() {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ACLableExistBuilderMain creatingParentContainersIfNeeded() {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }
    }

    private class MockGetChildrenBuilder
    extends MockBackgroundPathableBuilder<List<String>>
    implements GetChildrenBuilder {
        private MockGetChildrenBuilder() {
        }

        public WatchPathable<List<String>> storingStatIn(Stat stat) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        @Override
        public List<String> forPath(String path) throws Exception {
            return MockCuratorFramework.this.getChildren(path, MockCuratorFramework.this.fileSystem.root());
        }
    }

    private static class MockBackgroundPathableBuilder<T>
    implements BackgroundPathable<T>,
    Watchable<BackgroundPathable<T>> {
        private MockBackgroundPathableBuilder() {
        }

        public ErrorListenerPathable<T> inBackground() {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ErrorListenerPathable<T> inBackground(Object o) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ErrorListenerPathable<T> inBackground(BackgroundCallback backgroundCallback) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ErrorListenerPathable<T> inBackground(BackgroundCallback backgroundCallback, Object o) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ErrorListenerPathable<T> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ErrorListenerPathable<T> inBackground(BackgroundCallback backgroundCallback, Object o, Executor executor) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public T forPath(String s) throws Exception {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public BackgroundPathable<T> watched() {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public BackgroundPathable<T> usingWatcher(Watcher watcher) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public BackgroundPathable<T> usingWatcher(CuratorWatcher curatorWatcher) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }
    }

    private class MockCreateBuilder
    implements CreateBuilder {
        private boolean createParents = false;
        private CreateMode createMode = CreateMode.PERSISTENT;

        private MockCreateBuilder() {
        }

        public ProtectACLCreateModeStatPathAndBytesable<String> creatingParentsIfNeeded() {
            this.createParents = true;
            return new MockProtectACLCreateModeStatPathAndBytesable<String>(){

                public String forPath(String s, byte[] bytes) throws Exception {
                    return MockCuratorFramework.this.createNode(s, bytes, MockCreateBuilder.this.createParents, MockCreateBuilder.this.createMode, MockCuratorFramework.this.fileSystem.root(), MockCuratorFramework.this.listeners);
                }

                public String forPath(String s) throws Exception {
                    return MockCuratorFramework.this.createNode(s, new byte[0], MockCreateBuilder.this.createParents, MockCreateBuilder.this.createMode, MockCuratorFramework.this.fileSystem.root(), MockCuratorFramework.this.listeners);
                }
            };
        }

        public ProtectACLCreateModeStatPathAndBytesable<String> creatingParentContainersIfNeeded() {
            return new MockProtectACLCreateModeStatPathAndBytesable<String>(){

                public String forPath(String s, byte[] bytes) throws Exception {
                    return MockCuratorFramework.this.createNode(s, bytes, MockCreateBuilder.this.createParents, MockCreateBuilder.this.createMode, MockCuratorFramework.this.fileSystem.root(), MockCuratorFramework.this.listeners);
                }

                public String forPath(String s) throws Exception {
                    return MockCuratorFramework.this.createNode(s, new byte[0], MockCreateBuilder.this.createParents, MockCreateBuilder.this.createMode, MockCuratorFramework.this.fileSystem.root(), MockCuratorFramework.this.listeners);
                }
            };
        }

        @Deprecated
        public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ACLCreateModeStatBackgroundPathAndBytesable<String> withProtection() {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public String forPath(String s) throws Exception {
            return MockCuratorFramework.this.createNode(s, new byte[0], this.createParents, this.createMode, MockCuratorFramework.this.fileSystem.root(), MockCuratorFramework.this.listeners);
        }

        public String forPath(String s, byte[] bytes) throws Exception {
            return MockCuratorFramework.this.createNode(s, bytes, this.createParents, this.createMode, MockCuratorFramework.this.fileSystem.root(), MockCuratorFramework.this.listeners);
        }

        public ErrorListenerPathAndBytesable<String> inBackground() {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ErrorListenerPathAndBytesable<String> inBackground(Object o) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback, Object o) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback, Object o, Executor executor) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public CreateBuilderMain withTtl(long l) {
            return this;
        }

        public CreateBuilder2 orSetData() {
            return null;
        }

        public CreateBuilder2 orSetData(int i) {
            return null;
        }

        public CreateBackgroundModeStatACLable compressed() {
            return null;
        }

        public CreateProtectACLCreateModePathAndBytesable<String> storingStatIn(Stat stat) {
            return null;
        }

        public BackgroundPathAndBytesable<String> withACL(List<ACL> list) {
            return this;
        }

        public ACLBackgroundPathAndBytesable<String> withMode(CreateMode createMode) {
            this.createMode = createMode;
            return this;
        }

        public BackgroundPathAndBytesable<String> withACL(List<ACL> list, boolean b) {
            return this;
        }

        public CreateBuilder2 idempotent() {
            return null;
        }
    }

    private static abstract class MockProtectACLCreateModeStatPathAndBytesable<String>
    implements ProtectACLCreateModeStatPathAndBytesable<String> {
        private MockProtectACLCreateModeStatPathAndBytesable() {
        }

        public BackgroundPathAndBytesable<String> withACL(List<ACL> list) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public BackgroundPathAndBytesable<String> withACL(List<ACL> list, boolean b) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ProtectACLCreateModeStatPathAndBytesable<String> withMode(CreateMode createMode) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public ACLCreateModeBackgroundPathAndBytesable<String> withProtection() {
            return null;
        }

        public ErrorListenerPathAndBytesable<String> inBackground() {
            return null;
        }

        public ErrorListenerPathAndBytesable<String> inBackground(Object o) {
            return null;
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback) {
            return null;
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback, Object o) {
            return null;
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
            return null;
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback backgroundCallback, Object o, Executor executor) {
            return null;
        }

        public ACLBackgroundPathAndBytesable<String> storingStatIn(Stat stat) {
            return this;
        }
    }

    private class MockFileCache
    implements Curator.FileCache {
        private final Path path;

        public MockFileCache(Path path) {
            this.path = path;
        }

        @Override
        public void start() {
        }

        @Override
        public void addListener(NodeCacheListener listener) {
            MockCuratorFramework.this.listeners.add(this.path, listener);
        }

        @Override
        public ChildData getCurrentData() {
            MemoryFileSystem.Node node = MockCuratorFramework.this.fileSystem.root().getNode(Paths.get(this.path.toString(), new String[0]), false);
            if (node == null) {
                return null;
            }
            return new ChildData("/" + this.path.toString(), null, node.getContent());
        }

        @Override
        public void close() {
        }
    }

    private class MockDirectoryCache
    implements Curator.DirectoryCache {
        private final Path path;

        public MockDirectoryCache(Path path) {
            this.path = path;
        }

        @Override
        public void start() {
        }

        @Override
        public void addListener(PathChildrenCacheListener listener) {
            MockCuratorFramework.this.listeners.add(this.path, listener);
        }

        @Override
        public List<ChildData> getCurrentData() {
            ArrayList<ChildData> childData = new ArrayList<ChildData>();
            for (String childName : this.getChildren(this.path)) {
                Path childPath = this.path.append(childName);
                childData.add(new ChildData(childPath.getAbsolute(), null, this.getData(childPath).get()));
            }
            return childData;
        }

        @Override
        public ChildData getCurrentData(Path fullPath) {
            if (!fullPath.getParentPath().equals((Object)this.path)) {
                throw new IllegalArgumentException("Path '" + fullPath + "' is not a child path of '" + this.path + "'");
            }
            return this.getData(fullPath).map(bytes -> new ChildData(fullPath.getAbsolute(), null, bytes)).orElse(null);
        }

        @Override
        public void close() {
        }

        private List<String> getChildren(Path path) {
            try {
                return (List)MockCuratorFramework.this.getChildren().forPath(path.getAbsolute());
            }
            catch (KeeperException.NoNodeException e) {
                return List.of();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get children of " + path.getAbsolute(), e);
            }
        }

        private Optional<byte[]> getData(Path path) {
            try {
                return Optional.of((byte[])MockCuratorFramework.this.getData().forPath(path.getAbsolute()));
            }
            catch (KeeperException.NoNodeException e) {
                return Optional.empty();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get data at " + path.getAbsolute(), e);
            }
        }
    }

    private static class MockLongValue
    implements AtomicValue<Long> {
        private final AtomicLong value = new AtomicLong();

        public MockLongValue(long value) {
            this.value.set(value);
        }

        public boolean succeeded() {
            return true;
        }

        public void setValue(long value) {
            this.value.set(value);
        }

        public Long preValue() {
            return this.value.get();
        }

        public Long postValue() {
            return this.value.get();
        }

        public AtomicStats getStats() {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }
    }

    private class MockAtomicCounter
    extends DistributedAtomicLong {
        private boolean initialized;
        private MockLongValue value;

        public MockAtomicCounter(String path) {
            super((CuratorFramework)MockCuratorFramework.this, path, (RetryPolicy)new RetryForever(1000));
            this.initialized = false;
            this.value = new MockLongValue(0L);
        }

        public boolean initialize(Long value) {
            if (this.initialized) {
                return false;
            }
            this.value = new MockLongValue(value);
            this.initialized = true;
            return true;
        }

        public AtomicValue<Long> get() {
            if (this.value == null) {
                return new MockLongValue(0L);
            }
            return this.value;
        }

        public AtomicValue<Long> add(Long delta) {
            return this.trySet(this.value.postValue() + delta);
        }

        public AtomicValue<Long> subtract(Long delta) {
            return this.trySet(this.value.postValue() - delta);
        }

        public AtomicValue<Long> increment() {
            return this.trySet(this.value.postValue() + 1L);
        }

        public AtomicValue<Long> decrement() {
            return this.trySet(this.value.postValue() - 1L);
        }

        public AtomicValue<Long> trySet(Long longval) {
            this.value = new MockLongValue(longval);
            return this.value;
        }

        public void forceSet(Long newValue) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }

        public AtomicValue<Long> compareAndSet(Long expectedValue, Long newValue) {
            throw new UnsupportedOperationException("Not implemented in MockCurator");
        }
    }

    private class MockLock
    extends InterProcessSemaphoreMutex {
        public boolean timeoutOnLock;
        public boolean throwExceptionOnLock;
        private final String path;
        private Lock lock;

        public MockLock(String path) {
            super((CuratorFramework)MockCuratorFramework.this, path);
            this.timeoutOnLock = false;
            this.throwExceptionOnLock = false;
            this.lock = null;
            this.path = path;
        }

        public boolean acquire(long timeout, TimeUnit unit) {
            if (this.throwExceptionOnLock) {
                throw new CuratorLockException("Thrown by mock");
            }
            if (this.timeoutOnLock) {
                return false;
            }
            try {
                this.lock = MockCuratorFramework.this.locks.lock((Object)this.path, timeout, unit);
                return true;
            }
            catch (UncheckedTimeoutException e) {
                return false;
            }
        }

        public void acquire() {
            if (this.throwExceptionOnLock) {
                throw new CuratorLockException("Thrown by mock");
            }
            this.lock = MockCuratorFramework.this.locks.lock((Object)this.path);
        }

        public void release() {
            if (this.lock != null) {
                this.lock.close();
            }
        }
    }

    private class MockCompletionWaiter
    implements Curator.CompletionWaiter {
        private MockCompletionWaiter() {
        }

        @Override
        public void awaitCompletion(Duration timeout) {
            if (MockCuratorFramework.this.shouldTimeoutOnEnter) {
                throw new CompletionTimeoutException("");
            }
        }

        @Override
        public void notifyCompletion() {
        }
    }

    private class ListenerMap
    extends Listeners {
        private final Map<Path, PathChildrenCacheListener> directoryListeners = new ConcurrentHashMap<Path, PathChildrenCacheListener>();
        private final Map<Path, NodeCacheListener> fileListeners = new ConcurrentHashMap<Path, NodeCacheListener>();

        private ListenerMap() {
        }

        public void add(Path path, PathChildrenCacheListener listener) {
            this.directoryListeners.put(path, listener);
        }

        public void add(Path path, NodeCacheListener listener) {
            this.fileListeners.put(path, listener);
        }

        @Override
        public void notify(Path path, PathChildrenCacheEvent event) {
            try {
                HashSet<Map.Entry<Path, PathChildrenCacheListener>> directoryListenerSnapshot = new HashSet<Map.Entry<Path, PathChildrenCacheListener>>(this.directoryListeners.entrySet());
                for (Map.Entry entry : directoryListenerSnapshot) {
                    if (!path.isChildOf((Path)entry.getKey())) continue;
                    ((PathChildrenCacheListener)entry.getValue()).childEvent((CuratorFramework)MockCuratorFramework.this, event);
                }
                HashSet<Map.Entry<Path, NodeCacheListener>> fileListenerSnapshot = new HashSet<Map.Entry<Path, NodeCacheListener>>(this.fileListeners.entrySet());
                for (Map.Entry entry : fileListenerSnapshot) {
                    if (!path.equals(entry.getKey())) continue;
                    ((NodeCacheListener)entry.getValue()).nodeChanged();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Exception notifying listeners", e);
            }
        }
    }

    private static abstract class Listeners {
        private Listeners() {
        }

        public final void notify(Path path, byte[] data, PathChildrenCacheEvent.Type type) {
            String pathString = "/" + path.toString();
            PathChildrenCacheEvent event = new PathChildrenCacheEvent(type, new ChildData(pathString, null, data));
            this.notify(path, event);
        }

        public abstract void notify(Path var1, PathChildrenCacheEvent var2);
    }
}

