/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.cloud.config.CuratorConfig;
import com.yahoo.path.Path;
import com.yahoo.vespa.curator.ConnectionSpec;
import com.yahoo.vespa.curator.CuratorCompletionWaiter;
import com.yahoo.vespa.curator.Lock;
import com.yahoo.vespa.curator.NodeCacheWrapper;
import com.yahoo.vespa.curator.PathChildrenCacheWrapper;
import com.yahoo.vespa.curator.VespaZooKeeperFactory;
import com.yahoo.vespa.curator.api.VespaCurator;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.zookeeper.VespaZooKeeperServer;
import com.yahoo.vespa.zookeeper.client.ZkClientConfigBuilder;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.logging.Logger;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class Curator
implements VespaCurator,
AutoCloseable {
    private static final Logger LOG = Logger.getLogger(Curator.class.getName());
    private static final File ZK_CLIENT_CONFIG_FILE = new File(Defaults.getDefaults().underVespaHome("conf/zookeeper/zookeeper-client.cfg"));
    private static final Duration ZK_SESSION_TIMEOUT = Duration.ofSeconds(120L);
    private static final Duration ZK_CONNECTION_TIMEOUT = Duration.ofSeconds(30L);
    private static final Duration BASE_SLEEP_TIME = Duration.ofSeconds(1L);
    private static final int MAX_RETRIES = 10;
    private static final RetryPolicy DEFAULT_RETRY_POLICY = new ExponentialBackoffRetry((int)BASE_SLEEP_TIME.toMillis(), 10);
    protected final RetryPolicy retryPolicy = DEFAULT_RETRY_POLICY;
    private final CuratorFramework curatorFramework;
    private final ConnectionSpec connectionSpec;
    private final ConcurrentHashMap<Path, Lock> locks = new ConcurrentHashMap();

    public static Curator create(String connectionSpec) {
        return new Curator(ConnectionSpec.create(connectionSpec), Optional.of(ZK_CLIENT_CONFIG_FILE));
    }

    public static Curator create(String connectionSpec, Optional<File> clientConfigFile) {
        return new Curator(ConnectionSpec.create(connectionSpec), clientConfigFile);
    }

    @Inject
    public Curator(CuratorConfig curatorConfig, VespaZooKeeperServer server) {
        this(ConnectionSpec.create(curatorConfig.server(), CuratorConfig.Server::hostname, CuratorConfig.Server::port, curatorConfig.zookeeperLocalhostAffinity()), Optional.of(ZK_CLIENT_CONFIG_FILE));
    }

    public Curator(ConfigserverConfig configserverConfig, VespaZooKeeperServer server) {
        this(ConnectionSpec.create(configserverConfig.zookeeperserver(), ConfigserverConfig.Zookeeperserver::hostname, ConfigserverConfig.Zookeeperserver::port, configserverConfig.zookeeperLocalhostAffinity()), Optional.of(ZK_CLIENT_CONFIG_FILE));
    }

    protected Curator(String connectionSpec, String zooKeeperEnsembleConnectionSpec, Function<RetryPolicy, CuratorFramework> curatorFactory) {
        this(ConnectionSpec.create(connectionSpec, zooKeeperEnsembleConnectionSpec), curatorFactory.apply(DEFAULT_RETRY_POLICY));
    }

    Curator(ConnectionSpec connectionSpec, Optional<File> clientConfigFile) {
        this(connectionSpec, CuratorFrameworkFactory.builder().retryPolicy(DEFAULT_RETRY_POLICY).sessionTimeoutMs((int)ZK_SESSION_TIMEOUT.toMillis()).connectionTimeoutMs((int)ZK_CONNECTION_TIMEOUT.toMillis()).connectString(connectionSpec.local()).zookeeperFactory((ZookeeperFactory)new VespaZooKeeperFactory(Curator.createClientConfig(clientConfigFile))).dontUseContainerParents().build());
    }

    private Curator(ConnectionSpec connectionSpec, CuratorFramework curatorFramework) {
        this.connectionSpec = Objects.requireNonNull(connectionSpec);
        this.curatorFramework = Objects.requireNonNull(curatorFramework);
        this.addLoggingListener();
        curatorFramework.start();
    }

    private static ZKClientConfig createClientConfig(Optional<File> clientConfigFile) {
        if (clientConfigFile.isPresent()) {
            try {
                return new ZkClientConfigBuilder().toConfig(clientConfigFile.get().toPath());
            }
            catch (QuorumPeerConfig.ConfigException e) {
                throw new RuntimeException("Unable to create ZooKeeper client config file " + clientConfigFile.get());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new ZKClientConfig();
    }

    public String connectionSpec() {
        return this.connectionSpec.local();
    }

    public DistributedAtomicLong createAtomicCounter(String path) {
        return new DistributedAtomicLong(this.curatorFramework, path, (RetryPolicy)new ExponentialBackoffRetry((int)BASE_SLEEP_TIME.toMillis(), 10));
    }

    public InterProcessLock createMutex(String lockPath) {
        return new InterProcessMutex(this.curatorFramework, lockPath);
    }

    private void addLoggingListener() {
        this.curatorFramework.getConnectionStateListenable().addListener((curatorFramework, connectionState) -> {
            switch (connectionState) {
                case SUSPENDED: {
                    LOG.info("ZK connection state change: SUSPENDED");
                    break;
                }
                case RECONNECTED: {
                    LOG.info("ZK connection state change: RECONNECTED");
                    break;
                }
                case LOST: {
                    LOG.warning("ZK connection state change: LOST");
                }
            }
        });
    }

    public CompletionWaiter getCompletionWaiter(Path waiterPath, int numMembers, String id) {
        return CuratorCompletionWaiter.create(this, waiterPath, id);
    }

    public CompletionWaiter createCompletionWaiter(Path parentPath, String waiterNode, int numMembers, String id) {
        return CuratorCompletionWaiter.createAndInitialize(this, parentPath, waiterNode, id);
    }

    public DirectoryCache createDirectoryCache(String path, boolean cacheData, boolean dataIsCompressed, ExecutorService executorService) {
        return new PathChildrenCacheWrapper(this.framework(), path, cacheData, dataIsCompressed, executorService);
    }

    public FileCache createFileCache(String path, boolean dataIsCompressed) {
        return new NodeCacheWrapper(this.framework(), path, dataIsCompressed);
    }

    public boolean exists(Path path) {
        try {
            return this.framework().checkExists().forPath(path.getAbsolute()) != null;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not check existence of " + path.getAbsolute(), e);
        }
    }

    public void set(Path path, byte[] data) {
        if (!this.exists(path)) {
            this.create(path);
        }
        String absolutePath = path.getAbsolute();
        try {
            this.framework().setData().forPath(absolutePath, data);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set data at " + absolutePath, e);
        }
    }

    public boolean create(Path path) {
        if (this.exists(path)) {
            return false;
        }
        String absolutePath = path.getAbsolute();
        try {
            this.framework().create().creatingParentsIfNeeded().forPath(absolutePath, new byte[0]);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create " + absolutePath, e);
        }
        return true;
    }

    public void createAtomically(Path ... paths) {
        try {
            CuratorTransaction transaction = this.framework().inTransaction();
            for (Path path : paths) {
                if (this.exists(path)) continue;
                transaction = ((CuratorTransactionBridge)transaction.create().forPath(path.getAbsolute(), new byte[0])).and();
            }
            ((CuratorTransactionFinal)transaction).commit();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create " + Arrays.toString(paths), e);
        }
    }

    public void delete(Path path) {
        try {
            ((ChildrenDeletable)this.framework().delete().guaranteed()).deletingChildrenIfNeeded().forPath(path.getAbsolute());
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new RuntimeException("Could not delete " + path.getAbsolute(), e);
        }
    }

    public List<String> getChildren(Path path) {
        try {
            return (List)this.framework().getChildren().forPath(path.getAbsolute());
        }
        catch (KeeperException.NoNodeException e) {
            return List.of();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get children of " + path.getAbsolute(), e);
        }
    }

    public Optional<byte[]> getData(Path path) {
        try {
            return Optional.of((byte[])this.framework().getData().forPath(path.getAbsolute()));
        }
        catch (KeeperException.NoNodeException e) {
            return Optional.empty();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get data at " + path.getAbsolute(), e);
        }
    }

    public Optional<Stat> getStat(Path path) {
        try {
            return Optional.ofNullable((Stat)this.framework().checkExists().forPath(path.getAbsolute()));
        }
        catch (KeeperException.NoNodeException e) {
            return Optional.empty();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get data at " + path.getAbsolute(), e);
        }
    }

    public Lock lock(Path path, Duration timeout) {
        this.create(path);
        Lock lock = this.locks.computeIfAbsent(path, pathArg -> new Lock(pathArg.getAbsolute(), this));
        lock.acquire(timeout);
        return lock;
    }

    public CuratorFramework framework() {
        return this.curatorFramework;
    }

    @Override
    public void close() {
        this.curatorFramework.close();
    }

    public String zooKeeperEnsembleConnectionSpec() {
        return this.connectionSpec.ensemble();
    }

    public int zooKeeperEnsembleCount() {
        return this.connectionSpec.ensembleSize();
    }

    public static interface FileCache {
        public void start();

        public void addListener(NodeCacheListener var1);

        public ChildData getCurrentData();

        public void close();
    }

    public static interface DirectoryCache {
        public void start();

        public void addListener(PathChildrenCacheListener var1);

        public List<ChildData> getCurrentData();

        public ChildData getCurrentData(Path var1);

        public void close();
    }

    public static interface CompletionWaiter {
        public void awaitCompletion(Duration var1);

        public void notifyCompletion();
    }
}

