/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.yahoo.transaction.Mutex;
import com.yahoo.vespa.curator.Curator;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.locks.InterProcessLock;

public class Lock
implements Mutex {
    private final InterProcessLock mutex;
    private final String lockPath;

    public Lock(String lockPath, Curator curator) {
        this.lockPath = lockPath;
        this.mutex = curator.createMutex(lockPath);
    }

    public void acquire(Duration timeout) throws UncheckedTimeoutException {
        boolean acquired;
        try {
            acquired = this.mutex.acquire(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception acquiring lock '" + this.lockPath + "'", e);
        }
        if (!acquired) {
            throw new UncheckedTimeoutException("Timed out after waiting " + timeout + " to acquire lock '" + this.lockPath + "'");
        }
    }

    public void close() {
        try {
            this.mutex.release();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception releasing lock '" + this.lockPath + "'");
        }
    }
}

