/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.yahoo.log.LogLevel;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.curator.utils.DefaultZookeeperFactory;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

class DNSResolvingFixerZooKeeperFactory
implements ZookeeperFactory {
    public static final long UNKNOWN_HOST_WAIT_TIME_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private static final Logger log = Logger.getLogger(DNSResolvingFixerZooKeeperFactory.class.getName());
    private final DefaultZookeeperFactory zookeeperFactory;
    private final long maxTimeout;

    public DNSResolvingFixerZooKeeperFactory(long maxTimeout) {
        this.maxTimeout = maxTimeout;
        this.zookeeperFactory = new DefaultZookeeperFactory();
    }

    public ZooKeeper newZooKeeper(String connectString, int sessionTimeout, Watcher watcher, boolean canBeReadOnly) throws Exception {
        long endTime = System.currentTimeMillis() + this.maxTimeout;
        while (true) {
            try {
                return this.zookeeperFactory.newZooKeeper(connectString, sessionTimeout, watcher, canBeReadOnly);
            }
            catch (UnknownHostException e) {
                log.log(LogLevel.WARNING, "Error creating ZooKeeper handle", e);
                Thread.sleep(UNKNOWN_HOST_WAIT_TIME_MILLIS);
                if (System.currentTimeMillis() < endTime) continue;
                throw new RuntimeException("Error creating zookeeper handle within timeout");
            }
            break;
        }
    }
}

