/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.path.Path;
import com.yahoo.vespa.curator.CuratorCompletionWaiter;
import com.yahoo.vespa.curator.DNSResolvingFixerZooKeeperFactory;
import com.yahoo.vespa.curator.NodeCacheWrapper;
import com.yahoo.vespa.curator.PathChildrenCacheWrapper;
import com.yahoo.vespa.zookeeper.ZooKeeperServer;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.zookeeper.KeeperException;

public class Curator
implements AutoCloseable {
    private static final long UNKNOWN_HOST_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(30L);
    private static final int ZK_SESSION_TIMEOUT = 30000;
    private static final int ZK_CONNECTION_TIMEOUT = 30000;
    private static final int baseSleepTime = 1000;
    private static final int maxRetries = 10;
    private final CuratorFramework curatorFramework;
    protected final RetryPolicy retryPolicy;
    private final String connectionSpec;
    private final int serverCount;

    public static Curator create(String connectionSpec) {
        return new Curator(connectionSpec);
    }

    @Inject
    public Curator(ConfigserverConfig configserverConfig, ZooKeeperServer server) {
        this(Curator.createConnectionSpec(configserverConfig));
    }

    private static String createConnectionSpec(ConfigserverConfig config) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < config.zookeeperserver().size(); ++i) {
            ConfigserverConfig.Zookeeperserver server = config.zookeeperserver(i);
            sb.append(server.hostname());
            sb.append(":");
            sb.append(server.port());
            if (i >= config.zookeeperserver().size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public Curator(String connectionSpec) {
        Objects.requireNonNull(connectionSpec, "The curator connection spec cannot be null");
        this.connectionSpec = connectionSpec;
        this.serverCount = connectionSpec.split(",").length;
        Curator.validateConnectionSpec(connectionSpec);
        this.retryPolicy = new ExponentialBackoffRetry(1000, 10);
        this.curatorFramework = CuratorFrameworkFactory.builder().retryPolicy(this.retryPolicy).sessionTimeoutMs(30000).connectionTimeoutMs(30000).connectString(connectionSpec).zookeeperFactory((ZookeeperFactory)new DNSResolvingFixerZooKeeperFactory(UNKNOWN_HOST_TIMEOUT_MILLIS)).build();
        this.addFakeListener();
        this.curatorFramework.start();
    }

    protected Curator() {
        this.connectionSpec = "";
        this.serverCount = 0;
        this.retryPolicy = new ExponentialBackoffRetry(1000, 10);
        this.curatorFramework = null;
    }

    private static void validateConnectionSpec(String connectionSpec) {
        if (connectionSpec == null || connectionSpec.isEmpty()) {
            throw new IllegalArgumentException(String.format("Connections spec '%s' is not valid", connectionSpec));
        }
    }

    public int serverCount() {
        return this.serverCount;
    }

    public String connectionSpec() {
        return this.connectionSpec;
    }

    public DistributedAtomicLong createAtomicCounter(String path) {
        return new DistributedAtomicLong(this.curatorFramework, path, (RetryPolicy)new ExponentialBackoffRetry(1000, 10));
    }

    public InterProcessLock createMutex(String lockPath) {
        return new InterProcessMutex(this.curatorFramework, lockPath);
    }

    private void addFakeListener() {
        this.curatorFramework.getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

            public void stateChanged(CuratorFramework curatorFramework, ConnectionState connectionState) {
            }
        });
    }

    public CompletionWaiter getCompletionWaiter(Path waiterPath, int numMembers, String id) {
        return CuratorCompletionWaiter.create(this.curatorFramework, waiterPath, numMembers, id);
    }

    public CompletionWaiter createCompletionWaiter(Path parentPath, String waiterNode, int numMembers, String id) {
        return CuratorCompletionWaiter.createAndInitialize(this, parentPath, waiterNode, numMembers, id);
    }

    public DirectoryCache createDirectoryCache(String path, boolean cacheData, boolean dataIsCompressed, ExecutorService executorService) {
        return new PathChildrenCacheWrapper(this.framework(), path, cacheData, dataIsCompressed, executorService);
    }

    public FileCache createFileCache(String path, boolean dataIsCompressed) {
        return new NodeCacheWrapper(this.framework(), path, dataIsCompressed);
    }

    public boolean exists(Path path) {
        try {
            return this.framework().checkExists().forPath(path.getAbsolute()) != null;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not check existence of " + path.getAbsolute(), e);
        }
    }

    public void set(Path path, byte[] data) {
        String absolutePath = path.getAbsolute();
        try {
            if (!this.exists(path)) {
                this.framework().create().creatingParentsIfNeeded().forPath(absolutePath, data);
            } else {
                this.framework().setData().forPath(absolutePath, data);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set data at " + absolutePath, e);
        }
    }

    public void create(Path path) {
        if (this.exists(path)) {
            return;
        }
        String absolutePath = path.getAbsolute();
        try {
            this.framework().create().creatingParentsIfNeeded().forPath(absolutePath, new byte[0]);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create " + absolutePath, e);
        }
    }

    public void createAtomically(Path ... paths) {
        try {
            CuratorTransaction transaction = this.framework().inTransaction();
            for (Path path : paths) {
                if (this.exists(path)) continue;
                transaction = ((CuratorTransactionBridge)transaction.create().forPath(path.getAbsolute(), new byte[0])).and();
            }
            ((CuratorTransactionFinal)transaction).commit();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create " + Arrays.toString(paths), e);
        }
    }

    public void delete(Path path) {
        if (!this.exists(path)) {
            return;
        }
        try {
            this.framework().delete().guaranteed().deletingChildrenIfNeeded().forPath(path.getAbsolute());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not delete " + path.getAbsolute(), e);
        }
    }

    public List<String> getChildren(Path path) {
        if (!this.exists(path)) {
            return Collections.emptyList();
        }
        try {
            return (List)this.framework().getChildren().forPath(path.getAbsolute());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get children of " + path.getAbsolute(), e);
        }
    }

    public Optional<byte[]> getData(Path path) {
        if (!this.exists(path)) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.framework().getData().forPath(path.getAbsolute()));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get data at " + path.getAbsolute(), e);
        }
    }

    public CuratorFramework framework() {
        return this.curatorFramework;
    }

    @Override
    public void close() {
        this.curatorFramework.close();
    }

    public static interface FileCache {
        public void start();

        public void addListener(NodeCacheListener var1);

        public ChildData getCurrentData();

        public void close();
    }

    public static interface DirectoryCache {
        public void start();

        public void addListener(PathChildrenCacheListener var1);

        public List<ChildData> getCurrentData();

        public void close();
    }

    public static interface CompletionWaiter {
        public void awaitCompletion(Duration var1);

        public void notifyCompletion();
    }
}

