/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search.vsm;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class VsmsummaryConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "07145fe84cbe44e8e0d54c27f55971b4";
    public static final String CONFIG_DEF_NAME = "vsmsummary";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search.vsm";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search.vsm", "outputclass string default=\"\"", "fieldmap[].summary string", "fieldmap[].document[].field string", "fieldmap[].command enum { NONE, FLATTENJUNIPER, FLATTENSPACE } default=NONE"};
    private final StringNode outputclass;
    private final InnerNodeVector<Fieldmap> fieldmap;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public VsmsummaryConfig(Builder builder) {
        this(builder, true);
    }

    private VsmsummaryConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for vsmsummary must be initialized: " + builder.__uninitialized);
        }
        this.outputclass = builder.outputclass == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.outputclass);
        this.fieldmap = Fieldmap.createVector(builder.fieldmap);
    }

    public String outputclass() {
        return this.outputclass.value();
    }

    public List<Fieldmap> fieldmap() {
        return this.fieldmap;
    }

    public Fieldmap fieldmap(int i) {
        return (Fieldmap)((Object)this.fieldmap.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(VsmsummaryConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Fieldmap
    extends InnerNode {
        private final StringNode summary;
        private final InnerNodeVector<Document> document;
        private final Command command;

        public Fieldmap(Builder builder) {
            this(builder, true);
        }

        private Fieldmap(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for vsmsummary.fieldmap[] must be initialized: " + builder.__uninitialized);
            }
            this.summary = builder.summary == null ? new StringNode() : new StringNode(builder.summary);
            this.document = Document.createVector(builder.document);
            this.command = builder.command == null ? new Command(Command.NONE) : new Command(builder.command);
        }

        public String summary() {
            return this.summary.value();
        }

        public List<Document> document() {
            return this.document;
        }

        public Document document(int i) {
            return (Document)((Object)this.document.get(i));
        }

        public Command.Enum command() {
            return (Command.Enum)((Object)this.command.value());
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Fieldmap newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldmap");
            return changes;
        }

        private static InnerNodeVector<Fieldmap> createVector(List<Builder> builders) {
            ArrayList<Fieldmap> elems = new ArrayList<Fieldmap>();
            for (Builder b : builders) {
                elems.add(new Fieldmap(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Command
        extends EnumNode<Enum> {
            public static final Enum NONE = Enum.NONE;
            public static final Enum FLATTENJUNIPER = Enum.FLATTENJUNIPER;
            public static final Enum FLATTENSPACE = Enum.FLATTENSPACE;

            public Command() {
                this.value = null;
            }

            public Command(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                NONE,
                FLATTENJUNIPER,
                FLATTENSPACE;

            }
        }

        public static final class Document
        extends InnerNode {
            private final StringNode field;

            public Document(Builder builder) {
                this(builder, true);
            }

            private Document(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for vsmsummary.fieldmap[].document[] must be initialized: " + builder.__uninitialized);
                }
                this.field = builder.field == null ? new StringNode() : new StringNode(builder.field);
            }

            public String field() {
                return this.field.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Document newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("document");
                return changes;
            }

            private static InnerNodeVector<Document> createVector(List<Builder> builders) {
                ArrayList<Document> elems = new ArrayList<Document>();
                for (Builder b : builders) {
                    elems.add(new Document(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("field"));
                private String field = null;

                public Builder() {
                }

                public Builder(Document config) {
                    this.field(config.field());
                }

                private Builder override(Builder __superior) {
                    if (__superior.field != null) {
                        this.field(__superior.field);
                    }
                    return this;
                }

                public Builder field(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.field = __value;
                    this.__uninitialized.remove("field");
                    return this;
                }

                public Document build() {
                    return new Document(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("summary"));
            private String summary = null;
            public List<Document.Builder> document = new ArrayList<Document.Builder>();
            private Command.Enum command = null;

            public Builder() {
            }

            public Builder(Fieldmap config) {
                this.summary(config.summary());
                for (Document d : config.document()) {
                    this.document(new Document.Builder(d));
                }
                this.command(config.command());
            }

            private Builder override(Builder __superior) {
                if (__superior.summary != null) {
                    this.summary(__superior.summary);
                }
                if (!__superior.document.isEmpty()) {
                    this.document.addAll(__superior.document);
                }
                if (__superior.command != null) {
                    this.command(__superior.command);
                }
                return this;
            }

            public Builder summary(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.summary = __value;
                this.__uninitialized.remove("summary");
                return this;
            }

            public Builder document(Document.Builder __builder) {
                this.document.add(__builder);
                return this;
            }

            public Builder document(List<Document.Builder> __builders) {
                this.document = __builders;
                return this;
            }

            public Builder command(Command.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.command = __value;
                return this;
            }

            private Builder command(String __value) {
                return this.command(Command.Enum.valueOf(__value));
            }

            public Fieldmap build() {
                return new Fieldmap(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String outputclass = null;
        public List<Fieldmap.Builder> fieldmap = new ArrayList<Fieldmap.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(VsmsummaryConfig config) {
            this.outputclass(config.outputclass());
            for (Fieldmap f : config.fieldmap()) {
                this.fieldmap(new Fieldmap.Builder(f));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.outputclass != null) {
                this.outputclass(__superior.outputclass);
            }
            if (!__superior.fieldmap.isEmpty()) {
                this.fieldmap.addAll(__superior.fieldmap);
            }
            return this;
        }

        public Builder outputclass(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.outputclass = __value;
            return this;
        }

        public Builder fieldmap(Fieldmap.Builder __builder) {
            this.fieldmap.add(__builder);
            return this;
        }

        public Builder fieldmap(List<Fieldmap.Builder> __builders) {
            this.fieldmap = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return VsmsummaryConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return VsmsummaryConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return VsmsummaryConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public VsmsummaryConfig build() {
            return new VsmsummaryConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

