/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search.vsm;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class VsmfieldsConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "4b7c1ffae5c83dd0f11c1620f443800a";
    public static final String CONFIG_DEF_NAME = "vsmfields";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search.vsm";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search.vsm", "documentverificationlevel int default=0", "searchall int default=1", "fieldspec[].name string", "fieldspec[].searchmethod enum { NONE, BOOL, AUTOUTF8, UTF8, SSE2UTF8, INT8, INT16, INT32, INT64, FLOAT16, FLOAT, DOUBLE } default=AUTOUTF8", "fieldspec[].arg1 string default=\"\"", "fieldspec[].maxlength int default=1048576", "fieldspec[].fieldtype enum {ATTRIBUTE, INDEX} default=INDEX", "documenttype[].name string", "documenttype[].index[].name string", "documenttype[].index[].field[].name string"};
    private final IntegerNode documentverificationlevel;
    private final IntegerNode searchall;
    private final InnerNodeVector<Fieldspec> fieldspec;
    private final InnerNodeVector<Documenttype> documenttype;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public VsmfieldsConfig(Builder builder) {
        this(builder, true);
    }

    private VsmfieldsConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for vsmfields must be initialized: " + builder.__uninitialized);
        }
        this.documentverificationlevel = builder.documentverificationlevel == null ? new IntegerNode(0) : new IntegerNode(builder.documentverificationlevel.intValue());
        this.searchall = builder.searchall == null ? new IntegerNode(1) : new IntegerNode(builder.searchall.intValue());
        this.fieldspec = Fieldspec.createVector(builder.fieldspec);
        this.documenttype = Documenttype.createVector(builder.documenttype);
    }

    public int documentverificationlevel() {
        return this.documentverificationlevel.value();
    }

    public int searchall() {
        return this.searchall.value();
    }

    public List<Fieldspec> fieldspec() {
        return this.fieldspec;
    }

    public Fieldspec fieldspec(int i) {
        return (Fieldspec)((Object)this.fieldspec.get(i));
    }

    public List<Documenttype> documenttype() {
        return this.documenttype;
    }

    public Documenttype documenttype(int i) {
        return (Documenttype)((Object)this.documenttype.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(VsmfieldsConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Documenttype
    extends InnerNode {
        private final StringNode name;
        private final InnerNodeVector<Index> index;

        public Documenttype(Builder builder) {
            this(builder, true);
        }

        private Documenttype(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for vsmfields.documenttype[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.index = Index.createVector(builder.index);
        }

        public String name() {
            return this.name.value();
        }

        public List<Index> index() {
            return this.index;
        }

        public Index index(int i) {
            return (Index)((Object)this.index.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Documenttype newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("documenttype");
            return changes;
        }

        private static InnerNodeVector<Documenttype> createVector(List<Builder> builders) {
            ArrayList<Documenttype> elems = new ArrayList<Documenttype>();
            for (Builder b : builders) {
                elems.add(new Documenttype(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Index
        extends InnerNode {
            private final StringNode name;
            private final InnerNodeVector<Field> field;

            public Index(Builder builder) {
                this(builder, true);
            }

            private Index(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for vsmfields.documenttype[].index[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.field = Field.createVector(builder.field);
            }

            public String name() {
                return this.name.value();
            }

            public List<Field> field() {
                return this.field;
            }

            public Field field(int i) {
                return (Field)((Object)this.field.get(i));
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Index newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("index");
                return changes;
            }

            private static InnerNodeVector<Index> createVector(List<Builder> builders) {
                ArrayList<Index> elems = new ArrayList<Index>();
                for (Builder b : builders) {
                    elems.add(new Index(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Field
            extends InnerNode {
                private final StringNode name;

                public Field(Builder builder) {
                    this(builder, true);
                }

                private Field(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for vsmfields.documenttype[].index[].field[] must be initialized: " + builder.__uninitialized);
                    }
                    this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                }

                public String name() {
                    return this.name.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
                    return changes;
                }

                private static InnerNodeVector<Field> createVector(List<Builder> builders) {
                    ArrayList<Field> elems = new ArrayList<Field>();
                    for (Builder b : builders) {
                        elems.add(new Field(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
                    private String name = null;

                    public Builder() {
                    }

                    public Builder(Field config) {
                        this.name(config.name());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.name != null) {
                            this.name(__superior.name);
                        }
                        return this;
                    }

                    public Builder name(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.name = __value;
                        this.__uninitialized.remove("name");
                        return this;
                    }

                    public Field build() {
                        return new Field(this);
                    }
                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
                private String name = null;
                public List<Field.Builder> field = new ArrayList<Field.Builder>();

                public Builder() {
                }

                public Builder(Index config) {
                    this.name(config.name());
                    for (Field f : config.field()) {
                        this.field(new Field.Builder(f));
                    }
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (!__superior.field.isEmpty()) {
                        this.field.addAll(__superior.field);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder field(Field.Builder __builder) {
                    this.field.add(__builder);
                    return this;
                }

                public Builder field(List<Field.Builder> __builders) {
                    this.field = __builders;
                    return this;
                }

                public Index build() {
                    return new Index(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
            private String name = null;
            public List<Index.Builder> index = new ArrayList<Index.Builder>();

            public Builder() {
            }

            public Builder(Documenttype config) {
                this.name(config.name());
                for (Index i : config.index()) {
                    this.index(new Index.Builder(i));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (!__superior.index.isEmpty()) {
                    this.index.addAll(__superior.index);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder index(Index.Builder __builder) {
                this.index.add(__builder);
                return this;
            }

            public Builder index(List<Index.Builder> __builders) {
                this.index = __builders;
                return this;
            }

            public Documenttype build() {
                return new Documenttype(this);
            }
        }
    }

    public static final class Fieldspec
    extends InnerNode {
        private final StringNode name;
        private final Searchmethod searchmethod;
        private final StringNode arg1;
        private final IntegerNode maxlength;
        private final Fieldtype fieldtype;

        public Fieldspec(Builder builder) {
            this(builder, true);
        }

        private Fieldspec(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for vsmfields.fieldspec[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.searchmethod = builder.searchmethod == null ? new Searchmethod(Searchmethod.AUTOUTF8) : new Searchmethod(builder.searchmethod);
            this.arg1 = builder.arg1 == null ? new StringNode(VsmfieldsConfig.CONFIG_DEF_VERSION) : new StringNode(builder.arg1);
            this.maxlength = builder.maxlength == null ? new IntegerNode(0x100000) : new IntegerNode(builder.maxlength.intValue());
            this.fieldtype = builder.fieldtype == null ? new Fieldtype(Fieldtype.INDEX) : new Fieldtype(builder.fieldtype);
        }

        public String name() {
            return this.name.value();
        }

        public Searchmethod.Enum searchmethod() {
            return (Searchmethod.Enum)((Object)this.searchmethod.value());
        }

        public String arg1() {
            return this.arg1.value();
        }

        public int maxlength() {
            return this.maxlength.value();
        }

        public Fieldtype.Enum fieldtype() {
            return (Fieldtype.Enum)((Object)this.fieldtype.value());
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Fieldspec newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldspec");
            return changes;
        }

        private static InnerNodeVector<Fieldspec> createVector(List<Builder> builders) {
            ArrayList<Fieldspec> elems = new ArrayList<Fieldspec>();
            for (Builder b : builders) {
                elems.add(new Fieldspec(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Fieldtype
        extends EnumNode<Enum> {
            public static final Enum ATTRIBUTE = Enum.ATTRIBUTE;
            public static final Enum INDEX = Enum.INDEX;

            public Fieldtype() {
                this.value = null;
            }

            public Fieldtype(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                ATTRIBUTE,
                INDEX;

            }
        }

        public static final class Searchmethod
        extends EnumNode<Enum> {
            public static final Enum NONE = Enum.NONE;
            public static final Enum BOOL = Enum.BOOL;
            public static final Enum AUTOUTF8 = Enum.AUTOUTF8;
            public static final Enum UTF8 = Enum.UTF8;
            public static final Enum SSE2UTF8 = Enum.SSE2UTF8;
            public static final Enum INT8 = Enum.INT8;
            public static final Enum INT16 = Enum.INT16;
            public static final Enum INT32 = Enum.INT32;
            public static final Enum INT64 = Enum.INT64;
            public static final Enum FLOAT16 = Enum.FLOAT16;
            public static final Enum FLOAT = Enum.FLOAT;
            public static final Enum DOUBLE = Enum.DOUBLE;

            public Searchmethod() {
                this.value = null;
            }

            public Searchmethod(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                NONE,
                BOOL,
                AUTOUTF8,
                UTF8,
                SSE2UTF8,
                INT8,
                INT16,
                INT32,
                INT64,
                FLOAT16,
                FLOAT,
                DOUBLE;

            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
            private String name = null;
            private Searchmethod.Enum searchmethod = null;
            private String arg1 = null;
            private Integer maxlength = null;
            private Fieldtype.Enum fieldtype = null;

            public Builder() {
            }

            public Builder(Fieldspec config) {
                this.name(config.name());
                this.searchmethod(config.searchmethod());
                this.arg1(config.arg1());
                this.maxlength(config.maxlength());
                this.fieldtype(config.fieldtype());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.searchmethod != null) {
                    this.searchmethod(__superior.searchmethod);
                }
                if (__superior.arg1 != null) {
                    this.arg1(__superior.arg1);
                }
                if (__superior.maxlength != null) {
                    this.maxlength(__superior.maxlength);
                }
                if (__superior.fieldtype != null) {
                    this.fieldtype(__superior.fieldtype);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder searchmethod(Searchmethod.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.searchmethod = __value;
                return this;
            }

            private Builder searchmethod(String __value) {
                return this.searchmethod(Searchmethod.Enum.valueOf(__value));
            }

            public Builder arg1(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.arg1 = __value;
                return this;
            }

            public Builder maxlength(int __value) {
                this.maxlength = __value;
                return this;
            }

            private Builder maxlength(String __value) {
                return this.maxlength(Integer.valueOf(__value));
            }

            public Builder fieldtype(Fieldtype.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.fieldtype = __value;
                return this;
            }

            private Builder fieldtype(String __value) {
                return this.fieldtype(Fieldtype.Enum.valueOf(__value));
            }

            public Fieldspec build() {
                return new Fieldspec(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer documentverificationlevel = null;
        private Integer searchall = null;
        public List<Fieldspec.Builder> fieldspec = new ArrayList<Fieldspec.Builder>();
        public List<Documenttype.Builder> documenttype = new ArrayList<Documenttype.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(VsmfieldsConfig config) {
            this.documentverificationlevel(config.documentverificationlevel());
            this.searchall(config.searchall());
            for (Fieldspec f : config.fieldspec()) {
                this.fieldspec(new Fieldspec.Builder(f));
            }
            for (Documenttype d : config.documenttype()) {
                this.documenttype(new Documenttype.Builder(d));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.documentverificationlevel != null) {
                this.documentverificationlevel(__superior.documentverificationlevel);
            }
            if (__superior.searchall != null) {
                this.searchall(__superior.searchall);
            }
            if (!__superior.fieldspec.isEmpty()) {
                this.fieldspec.addAll(__superior.fieldspec);
            }
            if (!__superior.documenttype.isEmpty()) {
                this.documenttype.addAll(__superior.documenttype);
            }
            return this;
        }

        public Builder documentverificationlevel(int __value) {
            this.documentverificationlevel = __value;
            return this;
        }

        private Builder documentverificationlevel(String __value) {
            return this.documentverificationlevel(Integer.valueOf(__value));
        }

        public Builder searchall(int __value) {
            this.searchall = __value;
            return this;
        }

        private Builder searchall(String __value) {
            return this.searchall(Integer.valueOf(__value));
        }

        public Builder fieldspec(Fieldspec.Builder __builder) {
            this.fieldspec.add(__builder);
            return this;
        }

        public Builder fieldspec(List<Fieldspec.Builder> __builders) {
            this.fieldspec = __builders;
            return this;
        }

        public Builder documenttype(Documenttype.Builder __builder) {
            this.documenttype.add(__builder);
            return this;
        }

        public Builder documenttype(List<Documenttype.Builder> __builders) {
            this.documenttype = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return VsmfieldsConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return VsmfieldsConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return VsmfieldsConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public VsmfieldsConfig build() {
            return new VsmfieldsConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

