/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.log;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

@Deprecated(since="7")
public class LogLevel
extends Level {
    private static final Map<String, Level> nameToLevel;
    private static final Map<String, Level> uppercasedNameToLevel;
    private static final Map<Level, Level> javaToVespa;
    public static final int IntValEVENT = 1201;
    public static final int IntValFATAL = 1161;
    public static final int IntValERROR = 1101;
    public static final int IntValUNKNOWN = 1001;
    public static final int IntValSEVERE = 1000;
    public static final int IntValWARNING = 900;
    public static final int IntValINFO = 800;
    public static final int IntValCONFIG = 700;
    public static final int IntValDEBUG = 501;
    public static final int IntValFINE = 500;
    public static final int IntValFINER = 400;
    public static final int IntValFINEST = 300;
    public static final int IntValSPAM = 299;
    public static final int LogCtlFATAL = 0;
    public static final int LogCtlERROR = 1;
    public static final int LogCtlWARNING = 2;
    public static final int LogCtlCONFIG = 3;
    public static final int LogCtlINFO = 4;
    public static final int LogCtlEVENT = 5;
    public static final int LogCtlDEBUG = 6;
    public static final int LogCtlSPAM = 7;
    public static final int LogCtlNumLevels = 8;
    public static LogLevel UNKNOWN;
    public static LogLevel EVENT;
    public static LogLevel FATAL;
    public static LogLevel ERROR;
    public static LogLevel DEBUG;
    public static LogLevel SPAM;

    private LogLevel(String name, int value) {
        super(name, value);
    }

    public static Level parse(String name) {
        Level l = nameToLevel.get(name);
        if (l != null) {
            return l;
        }
        l = uppercasedNameToLevel.get(name);
        if (l != null) {
            return l;
        }
        return UNKNOWN;
    }

    public static Level getVespaLogLevel(Level level) {
        Level ll = javaToVespa.get(level);
        if (ll != null) {
            return ll;
        }
        int lv = level.intValue();
        if (lv > WARNING.intValue()) {
            return ERROR;
        }
        if (lv > INFO.intValue()) {
            return WARNING;
        }
        if (lv > DEBUG.intValue()) {
            return INFO;
        }
        if (lv > FINEST.intValue()) {
            return DEBUG;
        }
        return SPAM;
    }

    public static Map<String, Level> getLevels() {
        return nameToLevel;
    }

    static {
        UNKNOWN = new LogLevel("UNKNOWN", 1001);
        EVENT = new LogLevel("EVENT", 1201);
        FATAL = new LogLevel("FATAL", 1161);
        ERROR = new LogLevel("ERROR", 1101);
        DEBUG = new LogLevel("DEBUG", 501);
        SPAM = new LogLevel("SPAM", 299);
        javaToVespa = new HashMap<Level, Level>();
        javaToVespa.put(Level.SEVERE, ERROR);
        javaToVespa.put(Level.WARNING, WARNING);
        javaToVespa.put(Level.INFO, INFO);
        javaToVespa.put(Level.CONFIG, CONFIG);
        javaToVespa.put(Level.FINE, DEBUG);
        javaToVespa.put(Level.FINER, DEBUG);
        javaToVespa.put(Level.FINEST, SPAM);
        javaToVespa.put(FATAL, FATAL);
        javaToVespa.put(ERROR, ERROR);
        javaToVespa.put(EVENT, EVENT);
        javaToVespa.put(DEBUG, DEBUG);
        javaToVespa.put(SPAM, SPAM);
        nameToLevel = new LinkedHashMap<String, Level>(16);
        nameToLevel.put("fatal", FATAL);
        nameToLevel.put("error", ERROR);
        nameToLevel.put("warning", WARNING);
        nameToLevel.put("config", CONFIG);
        nameToLevel.put("info", INFO);
        nameToLevel.put("event", EVENT);
        nameToLevel.put("debug", DEBUG);
        nameToLevel.put("spam", SPAM);
        uppercasedNameToLevel = new LinkedHashMap<String, Level>(16);
        nameToLevel.forEach((name, level) -> uppercasedNameToLevel.put(name.toUpperCase(), (Level)level));
    }
}

