/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.log;

import com.yahoo.log.DefaultLevelController;
import com.yahoo.log.LevelController;
import com.yahoo.log.LevelControllerRepo;
import com.yahoo.log.LogSetup;
import com.yahoo.log.MappedLevelControllerRepo;
import com.yahoo.text.Utf8;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.TimerTask;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class VespaLevelControllerRepo
implements LevelControllerRepo {
    private RandomAccessFile ctlFile;
    private FileOutputStream ctlFileAppender;
    private MappedByteBuffer mapBuf;
    private MappedLevelControllerRepo levelControllerRepo;
    private final String logControlFilename;
    private final String appPrefix;
    private static final int maxPrefix = 64;
    private static final String CFHEADER = "Vespa log control file version 1\n";
    private static final String CFPREPRE = "Prefix: ";
    static final int controlFileHeaderLength = "Vespa log control file version 1\n".length() + "Prefix: ".length() + 1 + 64 + 1;
    static final int numLevels = 8;
    private LevelController defaultLevelCtrl;
    private CheckBackRunner checkBackRunner;

    VespaLevelControllerRepo(String logCtlFn, String logLevel, String applicationPrefix) {
        this.logControlFilename = logCtlFn;
        this.appPrefix = applicationPrefix;
        this.defaultLevelCtrl = new DefaultLevelController(logLevel);
        this.openCtlFile();
    }

    private void resetCtlFile() {
        Logger.getLogger("").setLevel(this.defaultLevelCtrl.getLevelLimit());
        try {
            if (this.ctlFile != null) {
                this.ctlFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.ctlFile = null;
        try {
            if (this.ctlFileAppender != null) {
                this.ctlFileAppender.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.ctlFileAppender = null;
        this.mapBuf = null;
        this.levelControllerRepo = null;
    }

    private void openCtlFile() {
        if (this.ctlFile != null) {
            return;
        }
        if (this.logControlFilename == null) {
            Logger.getLogger("").setLevel(this.defaultLevelCtrl.getLevelLimit());
            return;
        }
        try {
            this.ctlFile = new RandomAccessFile(this.logControlFilename, "rw");
            this.ctlFileAppender = new FileOutputStream(this.logControlFilename, true);
            this.ensureHeader();
            this.extendMapping();
            if (this.checkBackRunner == null) {
                this.checkBackRunner = new CheckBackRunner();
                LogSetup.getTaskRunner().schedule((TimerTask)this.checkBackRunner, 1000L, 2999L);
            }
        }
        catch (IOException e) {
            System.err.println("problem opening logcontrol file " + this.logControlFilename + ": " + e);
            this.resetCtlFile();
        }
    }

    private void ensureHeader() throws IOException {
        byte[] hbytes = Utf8.toBytes((String)CFHEADER);
        byte[] rbytes = new byte[hbytes.length];
        this.ctlFile.seek(0L);
        int l = this.ctlFile.read(rbytes);
        if (l != hbytes.length || !Arrays.equals(hbytes, rbytes)) {
            StringBuilder sb = new StringBuilder();
            sb.append(CFHEADER);
            sb.append(CFPREPRE);
            int appLen = 0;
            if (this.appPrefix != null) {
                appLen = this.appPrefix.length();
                sb.append(this.appPrefix);
            }
            sb.append('\n');
            for (int i = appLen; i < 66; ++i) {
                sb.append(' ');
            }
            sb.append('\n');
            this.ctlFile.write(sb.toString().getBytes(StandardCharsets.US_ASCII));
            this.ctlFile.setLength(this.ctlFile.getFilePointer());
            if (this.ctlFile.getFilePointer() != (long)(controlFileHeaderLength + 2)) {
                System.err.println("internal error, bad header length: " + this.ctlFile.getFilePointer() + " (should have been: " + (controlFileHeaderLength + 2) + ")");
            }
        }
    }

    private void extendMapping() throws IOException {
        if (this.ctlFile == null) {
            return;
        }
        long pos = 0L;
        long len = this.ctlFile.length();
        if (this.mapBuf == null || (long)this.mapBuf.capacity() != len) {
            this.mapBuf = this.ctlFile.getChannel().map(FileChannel.MapMode.READ_ONLY, pos, len);
        }
        this.levelControllerRepo = new MappedLevelControllerRepo(this.mapBuf, controlFileHeaderLength, 8, this.logControlFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LevelController getLevelControl(String suffix) {
        LevelController ctrl = null;
        if (this.levelControllerRepo != null) {
            if (suffix == null || suffix.equals("default")) {
                suffix = "";
            }
            if ((ctrl = this.levelControllerRepo.getLevelController(suffix)) != null) {
                return ctrl;
            }
            VespaLevelControllerRepo vespaLevelControllerRepo = this;
            synchronized (vespaLevelControllerRepo) {
                if (this.ctlFile == null) {
                    return this.defaultLevelCtrl;
                }
                int lastdot = suffix.lastIndexOf(46);
                LevelController inherit = lastdot != -1 ? this.getLevelControl(suffix.substring(0, lastdot)) : (suffix.equals("") ? this.defaultLevelCtrl : this.getLevelControl(""));
                try {
                    long len = this.ctlFile.length();
                    StringBuilder sb = new StringBuilder();
                    if (suffix.equals("")) {
                        sb.append("default: ");
                    } else {
                        sb.append(".").append(suffix).append(": ");
                    }
                    while ((len + (long)sb.length()) % 4L != 0L) {
                        sb.append(" ");
                    }
                    sb.append(inherit.getOnOffString()).append("\n");
                    byte[] lineBytes = sb.toString().getBytes(StandardCharsets.US_ASCII);
                    this.ctlFileAppender.write(lineBytes);
                    this.ctlFileAppender.flush();
                    this.ctlFile.seek(this.ctlFile.length());
                    this.extendMapping();
                    ctrl = this.levelControllerRepo.getLevelController(suffix);
                }
                catch (ClosedByInterruptException e) {
                    this.resetCtlFile();
                }
                catch (IOException e) {
                    System.err.println("error extending logcontrol file: " + e);
                    e.printStackTrace();
                    this.resetCtlFile();
                }
            }
        }
        if (ctrl == null) {
            return this.defaultLevelCtrl;
        }
        return ctrl;
    }

    private void checkBack() {
        if (this.levelControllerRepo != null) {
            Enumeration<String> e = LogManager.getLogManager().getLoggerNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                LevelController ctrl = this.getLevelControl(name);
                ctrl.checkBack();
            }
            this.levelControllerRepo.checkBack();
        }
    }

    @Override
    public LevelController getLevelController(String component) {
        return this.getLevelControl(component);
    }

    @Override
    public void close() {
        if (this.checkBackRunner != null) {
            this.checkBackRunner.cancel();
        }
    }

    private class CheckBackRunner
    extends TimerTask {
        private CheckBackRunner() {
        }

        @Override
        public void run() {
            VespaLevelControllerRepo.this.checkBack();
        }
    }
}

