/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.log;

import com.yahoo.log.Util;
import java.time.Instant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VespaFormat {
    private static final Pattern special = Pattern.compile("[\r\\\n\\\t\\\\]+");
    private static final Pattern newLine = Pattern.compile("\n");
    private static final Pattern carriage = Pattern.compile("\r");
    private static final Pattern tab = Pattern.compile("\t");
    private static final Pattern backSlash = Pattern.compile("\\\\");
    private static final String hostname = Util.getHostName();
    private static final String processID = Util.getPID();

    public static String escape(String s) {
        if (s == null) {
            return "(empty)";
        }
        Matcher m = special.matcher(s);
        if (!m.find()) {
            return s;
        }
        m = backSlash.matcher(s);
        if (m.find()) {
            s = m.replaceAll("\\\\\\\\");
        }
        if ((m = newLine.matcher(s)).find()) {
            s = m.replaceAll("\\\\n");
        }
        if ((m = carriage.matcher(s)).find()) {
            s = m.replaceAll("\\\\r");
        }
        if ((m = tab.matcher(s)).find()) {
            s = m.replaceAll("\\\\t");
        }
        return s;
    }

    @Deprecated(since="7", forRemoval=true)
    public static void formatTime(long time, StringBuilder sbuffer) {
        sbuffer.append(VespaFormat.formatTime(Instant.ofEpochMilli(time)));
    }

    public static String formatTime(Instant instant) {
        return String.format("%d.%06d", instant.getEpochSecond(), instant.getNano() / 1000);
    }

    @Deprecated(since="7", forRemoval=true)
    public static String format(String levelName, String component, String componentPrefix, long millis, String threadId, String serviceName, String formattedMessage, Throwable t) {
        StringBuilder sbuf = new StringBuilder(300);
        VespaFormat.formatTime(millis, sbuf);
        sbuf.append("\t");
        sbuf.append(hostname).append("\t");
        sbuf.append(processID);
        if (threadId != null) {
            sbuf.append("/").append(threadId);
        }
        sbuf.append("\t");
        sbuf.append(serviceName).append("\t");
        if (component == null && componentPrefix == null) {
            sbuf.append("-");
        } else if (component == null) {
            sbuf.append(componentPrefix);
        } else if (componentPrefix == null) {
            sbuf.append(".").append(component);
        } else {
            sbuf.append(componentPrefix).append(".").append(component);
        }
        sbuf.append("\t");
        sbuf.append(levelName).append("\t");
        sbuf.append(VespaFormat.escape(formattedMessage));
        if (t != null) {
            VespaFormat.formatException(t, sbuf);
        }
        sbuf.append("\n");
        return sbuf.toString();
    }

    @Deprecated(since="7", forRemoval=true)
    public static void formatException(Throwable t, StringBuilder sbuf) {
        Throwable last = t;
        int depth = 0;
        while (last != null) {
            sbuf.append("\\nmsg=\"");
            sbuf.append(VespaFormat.escape(last.getMessage()));
            sbuf.append("\"\\nname=\"");
            sbuf.append(VespaFormat.escape(last.getClass().getName()));
            sbuf.append("\"\\nstack=\"\\n");
            StackTraceElement[] st = last.getStackTrace();
            int stopAt = Math.min(st.length, 15);
            boolean first = true;
            for (int i = 0; i < stopAt; ++i) {
                if (first) {
                    first = false;
                } else {
                    sbuf.append("\\n");
                }
                sbuf.append(VespaFormat.escape(st[i].toString()));
            }
            if (stopAt < st.length) {
                sbuf.append("\\n[...]");
            }
            sbuf.append("\\n\"");
            last = last.getCause();
            ++depth;
        }
        sbuf.append(" nesting=").append(depth);
    }

    static String formatThreadProcess(long processId, long threadId) {
        if (threadId == 0L) {
            return Long.toString(processId);
        }
        return processId + "/" + threadId;
    }
}

