/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.log;

import com.yahoo.log.LogLevel;
import com.yahoo.log.Util;
import com.yahoo.log.VespaFormat;
import com.yahoo.log.event.Event;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VespaFormatter
extends SimpleFormatter {
    private static final Pattern backSlash = Pattern.compile("\\\\");
    private static final Pattern backSlashN = Pattern.compile("\\\\n");
    private static final Pattern backSlashT = Pattern.compile("\\\\t");
    private static final Pattern backSlash2 = Pattern.compile("\\\\\\\\");
    private static final String hostname = Util.getHostName();
    private static final String processID = Util.getPID();
    public static final String serviceNameUnsetValue = "-";
    private String serviceName;
    private final String componentPrefix;

    public VespaFormatter() {
        this.serviceName = serviceNameUnsetValue;
        this.componentPrefix = null;
    }

    public VespaFormatter(String serviceName, String componentPrefix) {
        this.serviceName = serviceName == null ? serviceNameUnsetValue : serviceName;
        this.componentPrefix = componentPrefix;
    }

    public static String unEscape(String s) {
        Matcher m = backSlash.matcher(s);
        if (!m.find()) {
            return s;
        }
        m = backSlashN.matcher(s);
        if (m.find()) {
            s = m.replaceAll("\n");
        }
        if ((m = backSlashT.matcher(s)).find()) {
            s = m.replaceAll("\t");
        }
        if ((m = backSlash2.matcher(s)).find()) {
            s = m.replaceAll("\\\\");
        }
        return s;
    }

    @Override
    public String format(LogRecord r) {
        StringBuilder sbuf = new StringBuilder(300);
        String levelName = LogLevel.getVespaLogLevel(r.getLevel()).toString().toLowerCase();
        String component = r.getLoggerName();
        sbuf.append(VespaFormat.formatTime(r.getInstant()));
        sbuf.append("\t");
        sbuf.append(hostname).append("\t").append(processID).append("/").append(r.getThreadID()).append("\t").append(this.serviceName).append("\t");
        if (component == null && this.componentPrefix == null) {
            sbuf.append(serviceNameUnsetValue);
        } else if (component == null) {
            sbuf.append(this.componentPrefix);
        } else if (this.componentPrefix == null) {
            sbuf.append(".").append(component);
        } else {
            sbuf.append(this.componentPrefix).append(".").append(component);
        }
        sbuf.append("\t").append(levelName).append("\t");
        if (r.getLevel() == LogLevel.EVENT) {
            Event event = (Event)r.getParameters()[0];
            sbuf.append(VespaFormat.escape(event.toString()));
        } else {
            sbuf.append(VespaFormat.escape(this.formatMessage(r)));
        }
        this.appendException(r.getThrown(), sbuf);
        sbuf.append("\n");
        return sbuf.toString();
    }

    private void appendException(Throwable throwable, StringBuilder builder) {
        if (throwable == null) {
            return;
        }
        String escapedStackTrace = VespaFormat.escape(this.stackTrace(throwable));
        builder.append("\\n").append("exception=").append("\\n").append(escapedStackTrace);
    }

    private String stackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter wrappedWriter = new PrintWriter(writer);
        throwable.printStackTrace(wrappedWriter);
        wrappedWriter.close();
        return writer.toString();
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public static String toMessageString(Throwable t) {
        StringBuilder b = new StringBuilder();
        String lastMessage = null;
        while (t != null) {
            String message = VespaFormatter.getMessage(t);
            if (message != null && !message.equals(lastMessage)) {
                if (b.length() > 0) {
                    b.append(": ");
                }
                b.append(message);
                lastMessage = message;
            }
            t = t.getCause();
        }
        return b.toString();
    }

    private static String getMessage(Throwable t) {
        String message = t.getMessage();
        if (t.getCause() == null && message == null) {
            return t.getClass().getSimpleName();
        }
        return message;
    }
}

