/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.log;

import com.yahoo.log.InvalidLogFormatException;
import com.yahoo.log.LogLevel;
import com.yahoo.log.VespaFormat;
import com.yahoo.log.event.Event;
import com.yahoo.log.event.MalformedEventException;
import java.time.Instant;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogMessage {
    private static Logger log = Logger.getLogger(LogMessage.class.getName());
    private static Pattern nativeFormat = Pattern.compile("^(\\d[^\t]+)\t([^\t]+)\t([^\t]+)\t([^\t]+)\t([^\t]+)\t([^\t]+)\t(.+)$");
    private Instant time;
    private String host;
    private long processId;
    private long threadId;
    private String service;
    private String component;
    private Level level;
    private String payload;
    private Event event;

    private LogMessage(Instant time, String host, long processId, long threadId, String service, String component, Level level, String payload) {
        this.time = time;
        this.host = host;
        this.processId = processId;
        this.threadId = threadId;
        this.service = service;
        this.component = component;
        this.level = level;
        this.payload = payload;
    }

    public static LogMessage of(Instant time, String host, long processId, long threadId, String service, String component, Level level, String payload) {
        return new LogMessage(time, host, processId, threadId, service, component, level, payload);
    }

    public Instant getTimestamp() {
        return this.time;
    }

    @Deprecated(since="7", forRemoval=true)
    public long getTime() {
        return this.time.toEpochMilli();
    }

    @Deprecated(since="7", forRemoval=true)
    public long getTimeInSeconds() {
        return this.time.getEpochSecond();
    }

    public String getHost() {
        return this.host;
    }

    public long getProcessId() {
        return this.processId;
    }

    public OptionalLong getThreadId() {
        return this.threadId > 0L ? OptionalLong.of(this.threadId) : OptionalLong.empty();
    }

    @Deprecated(since="7", forRemoval=true)
    public String getThreadProcess() {
        return VespaFormat.formatThreadProcess(this.processId, this.threadId);
    }

    public String getService() {
        return this.service;
    }

    public String getComponent() {
        return this.component;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getPayload() {
        return this.payload;
    }

    public static LogMessage parseNativeFormat(String msg) throws InvalidLogFormatException {
        Matcher m = nativeFormat.matcher(msg);
        if (!m.matches()) {
            throw new InvalidLogFormatException(msg);
        }
        Level msgLevel = LogLevel.parse(m.group(6));
        Instant timestamp = LogMessage.parseTimestamp(m.group(1));
        String threadProcess = m.group(3);
        return new LogMessage(timestamp, m.group(2), LogMessage.parseProcessId(threadProcess), LogMessage.parseThreadId(threadProcess), m.group(4), m.group(5), msgLevel, m.group(7));
    }

    private static Instant parseTimestamp(String timeStr) throws InvalidLogFormatException {
        try {
            int decimalSeparator = timeStr.indexOf(46);
            if (decimalSeparator == -1) {
                return Instant.ofEpochSecond(Long.parseLong(timeStr));
            }
            long seconds = Long.parseLong(timeStr.substring(0, decimalSeparator));
            long nanoseconds = Long.parseLong(String.format("%1$-9s", timeStr.substring(decimalSeparator + 1)).replace(' ', '0'));
            return Instant.ofEpochSecond(seconds, nanoseconds);
        }
        catch (NumberFormatException e) {
            throw new InvalidLogFormatException(String.format("Failed to parse timestamp: %s. Timestamp string: '%s'", e.getMessage(), timeStr), e);
        }
    }

    private static long parseProcessId(String threadProcess) {
        int slashIndex = threadProcess.indexOf(47);
        if (slashIndex == -1) {
            return Long.parseLong(threadProcess);
        }
        return Long.parseLong(threadProcess.substring(0, slashIndex));
    }

    private static long parseThreadId(String threadProcess) {
        int slashIndex = threadProcess.indexOf(47);
        if (slashIndex == -1) {
            return 0L;
        }
        return Long.parseLong(threadProcess.substring(slashIndex + 1));
    }

    public Event getEvent() throws MalformedEventException {
        if (this.level == LogLevel.EVENT && this.event == null) {
            try {
                this.event = Event.parse(this.getPayload());
                this.event.setTime(this.time.toEpochMilli());
            }
            catch (MalformedEventException e) {
                log.log((Level)LogLevel.DEBUG, "Got malformed event: " + this.getPayload());
                throw e;
            }
        }
        return this.event;
    }

    public String toString() {
        String threadProcess = VespaFormat.formatThreadProcess(this.processId, this.threadId);
        String timeStr = VespaFormat.formatTime(this.time);
        return new StringBuilder(timeStr.length() + this.host.length() + threadProcess.length() + this.service.length() + this.component.length() + this.level.toString().length() + this.payload.length() + 1).append(timeStr).append("\t").append(this.host).append("\t").append(threadProcess).append("\t").append(this.service).append("\t").append(this.component).append("\t").append(this.level.toString().toLowerCase()).append("\t").append(this.payload).append("\n").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogMessage that = (LogMessage)o;
        return this.processId == that.processId && this.threadId == that.threadId && Objects.equals(this.time, that.time) && Objects.equals(this.host, that.host) && Objects.equals(this.service, that.service) && Objects.equals(this.component, that.component) && Objects.equals(this.level, that.level) && Objects.equals(this.payload, that.payload) && Objects.equals(this.event, that.event);
    }

    public int hashCode() {
        return Objects.hash(this.time, this.host, this.processId, this.threadId, this.service, this.component, this.level, this.payload, this.event);
    }
}

