/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.log;

import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class LogFileDb {
    static final String DBDIR = "var/db/vespa/logfiledb/";

    private static long dayStamp() {
        long s = System.currentTimeMillis() / 1000L;
        return s / 100000L;
    }

    private static OutputStream metaFile() throws IOException {
        String fn = Defaults.getDefaults().underVespaHome("var/db/vespa/logfiledb/logfiles." + LogFileDb.dayStamp());
        File dir = new File(fn).getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            System.err.println("Failed creating logfiledb directory '" + dir.getPath() + "'.");
        }
        Path path = Paths.get(fn, new String[0]);
        return Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }

    public static boolean nowLoggingTo(String filename) {
        if (filename.contains("\n")) {
            throw new IllegalArgumentException("Cannot use filename with newline: " + filename);
        }
        long s = System.currentTimeMillis() / 1000L;
        String meta = s + " " + filename + "\n";
        byte[] data = meta.getBytes(StandardCharsets.UTF_8);
        try (OutputStream out = LogFileDb.metaFile();){
            out.write(data);
        }
        catch (IOException e) {
            System.err.println("Saving meta-data about logfile " + filename + " failed: " + e);
            return false;
        }
        return true;
    }
}

