/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.log;

import com.yahoo.log.InvalidLogFormatException;
import com.yahoo.log.LogLevel;
import com.yahoo.log.event.Event;
import com.yahoo.log.event.MalformedEventException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogMessage {
    private static Logger log = Logger.getLogger(LogMessage.class.getName());
    private static Pattern nativeFormat = Pattern.compile("^(\\d[^\t]+)\t([^\t]+)\t([^\t]+)\t([^\t]+)\t([^\t]+)\t([^\t]+)\t(.+)$");
    private long time;
    private String timeStr;
    private String host;
    private String threadProcess;
    private String service;
    private String component;
    private Level level;
    private String payload;
    private Event event;

    private LogMessage(String timeStr, Long time, String host, String threadProcess, String service, String component, Level level, String payload) {
        this.timeStr = timeStr;
        this.time = time;
        this.host = host;
        this.threadProcess = threadProcess;
        this.service = service;
        this.component = component;
        this.level = level;
        this.payload = payload;
    }

    public long getTime() {
        return this.time;
    }

    public long getTimeInSeconds() {
        return this.time / 1000L;
    }

    public String getHost() {
        return this.host;
    }

    public String getThreadProcess() {
        return this.threadProcess;
    }

    public String getService() {
        return this.service;
    }

    public String getComponent() {
        return this.component;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getPayload() {
        return this.payload;
    }

    public static LogMessage parseNativeFormat(String msg) throws InvalidLogFormatException {
        Matcher m = nativeFormat.matcher(msg);
        if (!m.matches()) {
            throw new InvalidLogFormatException(msg);
        }
        Level msgLevel = LogLevel.parse(m.group(6));
        Long timestamp = LogMessage.parseTimestamp(m.group(1));
        return new LogMessage(m.group(1), timestamp, m.group(2), m.group(3), m.group(4), m.group(5), msgLevel, m.group(7));
    }

    private static long parseTimestamp(String timeStr) throws InvalidLogFormatException {
        try {
            return (long)(Double.parseDouble(timeStr) * 1000.0);
        }
        catch (NumberFormatException e) {
            throw new InvalidLogFormatException("Invalid time string:" + timeStr);
        }
    }

    public Event getEvent() throws MalformedEventException {
        if (this.level == LogLevel.EVENT && this.event == null) {
            try {
                this.event = Event.parse(this.getPayload());
                this.event.setTime(this.time);
            }
            catch (MalformedEventException e) {
                log.log((Level)LogLevel.DEBUG, "Got malformed event: " + this.getPayload());
                throw e;
            }
        }
        return this.event;
    }

    public String toString() {
        return new StringBuilder(this.timeStr.length() + this.host.length() + this.threadProcess.length() + this.service.length() + this.component.length() + this.level.toString().length() + this.payload.length() + 1).append(this.timeStr).append("\t").append(this.host).append("\t").append(this.threadProcess).append("\t").append(this.service).append("\t").append(this.component).append("\t").append(this.level.toString().toLowerCase()).append("\t").append(this.payload).append("\n").toString();
    }
}

