/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.MixedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.TensorTypeParser;
import com.yahoo.tensor.serialization.JsonFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class TensorParser {
    TensorParser() {
    }

    static Tensor tensorFrom(String tensorString, Optional<TensorType> explicitType) {
        try {
            return TensorParser.tensorFromBody(tensorString, explicitType);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not parse '" + tensorString + "' as a tensor" + (String)(explicitType.isPresent() ? " of type " + explicitType.get() : ""), e);
        }
    }

    static Tensor tensorFromBody(String tensorString, Optional<TensorType> explicitType) {
        String valueString;
        Optional<TensorType> type;
        ArrayList<String> dimensionOrder;
        if ((tensorString = tensorString.trim()).startsWith("tensor")) {
            int colonIndex = tensorString.indexOf(58);
            String typeString = tensorString.substring(0, colonIndex);
            dimensionOrder = new ArrayList<String>();
            TensorType typeFromString = TensorTypeParser.fromSpec(typeString, dimensionOrder);
            if (explicitType.isPresent() && !explicitType.get().equals(typeFromString)) {
                throw new IllegalArgumentException("Got tensor with type string '" + typeString + "', but was passed type " + explicitType.get());
            }
            type = Optional.of(typeFromString);
            valueString = tensorString.substring(colonIndex + 1);
        } else {
            type = explicitType;
            valueString = tensorString;
            dimensionOrder = null;
        }
        valueString = valueString.trim();
        if (valueString.startsWith("{") && (type.isEmpty() || type.get().rank() == 0 || valueString.substring(1).trim().startsWith("{") || valueString.substring(1).trim().equals("}"))) {
            return TensorParser.tensorFromMappedValueString(valueString, type);
        }
        if (valueString.startsWith("{")) {
            return TensorParser.tensorFromMixedValueString(valueString, type, dimensionOrder);
        }
        if (valueString.startsWith("[")) {
            return TensorParser.tensorFromDenseValueString(valueString, type, dimensionOrder);
        }
        Optional<Tensor> t = TensorParser.maybeFromBinaryValueString(valueString, type, dimensionOrder);
        if (t.isPresent()) {
            return t.get();
        }
        if (explicitType.isPresent() && !explicitType.get().equals(TensorType.empty)) {
            throw new IllegalArgumentException("Got a zero-dimensional tensor value ('" + tensorString + "') where type " + explicitType.get() + " is required");
        }
        try {
            return Tensor.Builder.of(TensorType.empty).cell(Double.parseDouble(tensorString), new long[0]).build();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Excepted a number or a string starting by {, [ or tensor(...):, got '" + tensorString + "'");
        }
    }

    private static TensorType typeFromMappedValueString(String valueString) {
        TensorType.Builder builder = new TensorType.Builder();
        MappedValueTypeParser parser = new MappedValueTypeParser(valueString, builder);
        parser.parse();
        return builder.build();
    }

    private static Tensor tensorFromMappedValueString(String valueString, Optional<TensorType> type) {
        try {
            valueString = valueString.trim();
            Tensor.Builder builder = Tensor.Builder.of(type.orElse(TensorParser.typeFromMappedValueString(valueString)));
            MappedValueParser parser = new MappedValueParser(valueString, builder);
            parser.parse();
            return builder.build();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Excepted a number or a string starting by '{' or 'tensor('");
        }
    }

    private static Tensor tensorFromMixedValueString(String valueString, Optional<TensorType> type, List<String> dimensionOrder) {
        if (type.isEmpty()) {
            throw new IllegalArgumentException("The mixed tensor form requires an explicit tensor type on the form 'tensor(dimensions):...");
        }
        if (type.get().dimensions().stream().filter(d -> !d.isIndexed()).count() > 1L) {
            throw new IllegalArgumentException("The mixed tensor form requires a type with a single mapped dimension, but got " + type.get());
        }
        try {
            valueString = valueString.trim();
            if (!valueString.startsWith("{") && valueString.endsWith("}")) {
                throw new IllegalArgumentException("A mixed tensor must be enclosed in {}");
            }
            Tensor.Builder builder = Tensor.Builder.of(type.get());
            MixedValueParser parser = new MixedValueParser(valueString, dimensionOrder, builder);
            parser.parse();
            return builder.build();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Excepted a number or a string starting by '{' or 'tensor('");
        }
    }

    private static Optional<Tensor> maybeFromBinaryValueString(String valueString, Optional<TensorType> optType, List<String> dimensionOrder) {
        if (optType.isEmpty() || dimensionOrder != null) {
            return Optional.empty();
        }
        TensorType type = optType.get();
        long sz = 1L;
        for (TensorType.Dimension d : type.dimensions()) {
            sz *= d.size().orElse(0L).longValue();
        }
        if (sz == 0L || type.dimensions().size() == 0 || (long)valueString.length() < sz * 2L || valueString.chars().anyMatch(ch -> Character.digit(ch, 16) == -1)) {
            return Optional.empty();
        }
        try {
            double[] values = JsonFormat.decodeHexString(valueString, type.valueType());
            if ((long)values.length != sz) {
                return Optional.empty();
            }
            IndexedTensor.Builder builder = IndexedTensor.Builder.of(type);
            IndexedTensor.DirectIndexBuilder dib = (IndexedTensor.DirectIndexBuilder)((Object)builder);
            int i = 0;
            while ((long)i < sz) {
                dib.cellByDirectIndex((long)i, values[i]);
                ++i;
            }
            return Optional.of(builder.build());
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private static Tensor tensorFromDenseValueString(String valueString, Optional<TensorType> type, List<String> dimensionOrder) {
        if (type.isEmpty()) {
            throw new IllegalArgumentException("The dense tensor form requires an explicit tensor type on the form 'tensor(dimensions):...");
        }
        IndexedTensor.Builder builder = IndexedTensor.Builder.of(type.get());
        if (type.get().dimensions().stream().anyMatch(d -> d.size().isEmpty())) {
            new UnboundDenseValueParser(valueString, builder).parse();
            return TensorParser.checkBoundDimensionSizes(builder.build());
        }
        new DenseValueParser(valueString, dimensionOrder, (IndexedTensor.BoundBuilder)builder).parse();
        return builder.build();
    }

    private static Tensor checkBoundDimensionSizes(IndexedTensor tensor) {
        TensorType type = tensor.type();
        for (int i = 0; i < type.dimensions().size(); ++i) {
            TensorType.Dimension dimension = type.dimensions().get(i);
            if (!dimension.size().isPresent() || dimension.size().get().longValue() == tensor.dimensionSizes().size(i)) continue;
            throw new IllegalArgumentException("Unexpected size " + tensor.dimensionSizes().size(i) + " for dimension " + dimension.name() + " for type " + type);
        }
        return tensor;
    }

    private static class MappedValueTypeParser
    extends ValueParser {
        private final TensorType.Builder builder;

        public MappedValueTypeParser(String string, TensorType.Builder builder) {
            super(string);
            this.builder = builder;
        }

        public void parse() {
            this.consume('{');
            this.consumeLabels();
        }

        private void consumeLabels() {
            if (!this.consumeOptional('{')) {
                return;
            }
            while (!this.consumeOptional('}')) {
                String dimension = this.consumeIdentifier();
                this.consume(':');
                this.consumeLabel();
                this.builder.mapped(dimension);
                this.consumeOptional(',');
            }
        }
    }

    private static class MappedValueParser
    extends ValueParser {
        private final Tensor.Builder builder;

        public MappedValueParser(String string, Tensor.Builder builder) {
            super(string);
            this.builder = builder;
        }

        private void parse() {
            this.consume('{');
            this.skipSpace();
            while (this.position + 1 < this.string.length()) {
                TensorAddress address = this.consumeLabels();
                if (!address.isEmpty()) {
                    this.consume(':');
                } else {
                    this.consumeOptional(':');
                }
                int valueEnd = this.string.indexOf(44, this.position);
                if (valueEnd < 0 && (valueEnd = this.string.indexOf(125, this.position)) < 0) {
                    throw new IllegalArgumentException("A mapped tensor string must end by '}'");
                }
                TensorType.Value cellValueType = this.builder.type().valueType();
                String cellValueString = this.string.substring(this.position, valueEnd).trim();
                try {
                    switch (cellValueType) {
                        case DOUBLE: {
                            this.builder.cell(address, Double.parseDouble(cellValueString));
                            break;
                        }
                        case FLOAT: {
                            this.builder.cell(address, Float.parseFloat(cellValueString));
                            break;
                        }
                        case BFLOAT16: {
                            this.builder.cell(address, Float.parseFloat(cellValueString));
                            break;
                        }
                        case INT8: {
                            this.builder.cell(address, Float.parseFloat(cellValueString));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(cellValueType + " is not supported");
                        }
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("At " + address.toString(this.builder.type()) + ": '" + cellValueString + "' is not a valid " + cellValueType);
                }
                this.position = valueEnd + 1;
                this.skipSpace();
            }
        }

        private TensorAddress consumeLabels() {
            TensorAddress.Builder addressBuilder = new TensorAddress.Builder(this.builder.type());
            if (!this.consumeOptional('{')) {
                return addressBuilder.build();
            }
            while (!this.consumeOptional('}')) {
                String dimension = this.consumeIdentifier();
                this.consume(':');
                String label = this.consumeLabel();
                addressBuilder.add(dimension, label);
                this.consumeOptional(',');
            }
            return addressBuilder.build();
        }
    }

    private static class MixedValueParser
    extends ValueParser {
        private final Tensor.Builder builder;
        private List<String> dimensionOrder;

        public MixedValueParser(String string, List<String> dimensionOrder, Tensor.Builder builder) {
            super(string);
            this.dimensionOrder = dimensionOrder;
            this.builder = builder;
        }

        private void parse() {
            TensorType.Dimension mappedDimension = this.findMappedDimension();
            TensorType mappedSubtype = MixedTensor.createPartialType(this.builder.type().valueType(), List.of(mappedDimension));
            if (this.dimensionOrder != null) {
                this.dimensionOrder.remove(mappedDimension.name());
            }
            this.skipSpace();
            this.consume('{');
            this.skipSpace();
            while (this.position + 1 < this.string.length()) {
                String label = this.consumeLabel();
                this.consume(':');
                TensorAddress mappedAddress = new TensorAddress.Builder(mappedSubtype).add(mappedDimension.name(), label).build();
                if (this.builder.type().rank() > 1) {
                    this.parseDenseSubspace(mappedAddress, this.dimensionOrder);
                } else {
                    this.consumeNumber(mappedAddress);
                }
                if (!this.consumeOptional(',')) {
                    this.consume('}');
                }
                this.skipSpace();
            }
        }

        private TensorType.Dimension findMappedDimension() {
            Optional<TensorType.Dimension> mappedDimension = this.builder.type().dimensions().stream().filter(d -> d.isMapped()).findAny();
            if (mappedDimension.isPresent()) {
                return mappedDimension.get();
            }
            if (this.builder.type().rank() == 1 && this.builder.type().dimensions().get(0).size().isEmpty()) {
                return this.builder.type().dimensions().get(0);
            }
            throw new IllegalStateException("No suitable dimension in " + this.builder.type() + " for parsing as a mixed tensor. This is a bug.");
        }

        private void parseDenseSubspace(TensorAddress mappedAddress, List<String> denseDimensionOrder) {
            DenseValueParser denseParser = new DenseValueParser(this.string.substring(this.position), denseDimensionOrder, ((MixedTensor.BoundBuilder)this.builder).denseSubspaceBuilder(mappedAddress));
            denseParser.parse();
            this.position += denseParser.position();
        }

        private void consumeNumber(TensorAddress address) {
            Number number = this.consumeNumber(this.builder.type().valueType());
            switch (this.builder.type().valueType()) {
                case DOUBLE: {
                    this.builder.cell(address, (double)((Double)number));
                    break;
                }
                case FLOAT: {
                    this.builder.cell(address, ((Float)number).floatValue());
                    break;
                }
                case BFLOAT16: {
                    this.builder.cell(address, ((Float)number).floatValue());
                    break;
                }
                case INT8: {
                    this.builder.cell(address, ((Float)number).floatValue());
                }
            }
        }
    }

    private static class UnboundDenseValueParser
    extends ValueParser {
        private final IndexedTensor.Builder builder;
        private final long[] indexes;

        public UnboundDenseValueParser(String string, IndexedTensor.Builder builder) {
            super(string);
            this.builder = builder;
            this.indexes = new long[builder.type().dimensions().size()];
        }

        public void parse() {
            this.consumeList(0);
        }

        private void consumeList(int dimension) {
            this.consume('[');
            this.indexes[dimension] = 0L;
            while (!this.atListEnd()) {
                if (this.isInnerMostDimension(dimension)) {
                    this.consumeNumber();
                } else {
                    this.consumeList(dimension + 1);
                }
                int n = dimension;
                this.indexes[n] = this.indexes[n] + 1L;
                this.consumeOptional(',');
            }
            this.consume(']');
        }

        private void consumeNumber() {
            Number number = this.consumeNumber(this.builder.type().valueType());
            switch (this.builder.type().valueType()) {
                case DOUBLE: {
                    this.builder.cell((Double)number, this.indexes);
                    break;
                }
                case FLOAT: {
                    this.builder.cell(((Float)number).floatValue(), this.indexes);
                    break;
                }
                case BFLOAT16: {
                    this.builder.cell(((Float)number).floatValue(), this.indexes);
                    break;
                }
                case INT8: {
                    this.builder.cell(((Float)number).floatValue(), this.indexes);
                }
            }
        }

        private boolean isInnerMostDimension(int dimension) {
            return dimension == this.indexes.length - 1;
        }

        protected boolean atListEnd() {
            this.skipSpace();
            if (this.position >= this.string.length()) {
                throw new IllegalArgumentException("At value position " + this.position + ": Expected a ']' but got the end of the string");
            }
            return this.string.charAt(this.position) == ']';
        }
    }

    private static class DenseValueParser
    extends ValueParser {
        private final IndexedTensor.DirectIndexBuilder builder;
        private final IndexedTensor.Indexes indexes;
        private final boolean hasInnerStructure;

        public DenseValueParser(String string, List<String> dimensionOrder, IndexedTensor.DirectIndexBuilder builder) {
            super(string);
            this.builder = builder;
            this.indexes = IndexedTensor.Indexes.of(builder.type(), dimensionOrder);
            this.hasInnerStructure = DenseValueParser.hasInnerStructure(string);
        }

        public void parse() {
            if (!this.hasInnerStructure) {
                this.consume('[');
            }
            while (this.indexes.hasNext()) {
                int i;
                this.indexes.next();
                for (i = 0; i < this.indexes.nextDimensionsAtStart() && this.hasInnerStructure; ++i) {
                    this.consume('[');
                }
                this.consumeNumber();
                for (i = 0; i < this.indexes.nextDimensionsAtEnd() && this.hasInnerStructure; ++i) {
                    this.consume(']');
                }
                if (!this.indexes.hasNext()) continue;
                this.consume(',');
            }
            if (!this.hasInnerStructure) {
                this.consume(']');
            }
        }

        public int position() {
            return this.position;
        }

        private static boolean hasInnerStructure(String valueString) {
            valueString = valueString.trim();
            int firstLeftBracket = (valueString = valueString.substring(1)).indexOf(91);
            return firstLeftBracket >= 0 && firstLeftBracket < valueString.indexOf(93);
        }

        protected void consumeNumber() {
            Number number = this.consumeNumber(this.builder.type().valueType());
            switch (this.builder.type().valueType()) {
                case DOUBLE: {
                    this.builder.cellByDirectIndex(this.indexes.toSourceValueIndex(), (Double)number);
                    break;
                }
                case FLOAT: {
                    this.builder.cellByDirectIndex(this.indexes.toSourceValueIndex(), ((Float)number).floatValue());
                    break;
                }
                case BFLOAT16: {
                    this.builder.cellByDirectIndex(this.indexes.toSourceValueIndex(), ((Float)number).floatValue());
                    break;
                }
                case INT8: {
                    this.builder.cellByDirectIndex(this.indexes.toSourceValueIndex(), ((Float)number).floatValue());
                }
            }
        }
    }

    private static abstract class ValueParser {
        protected final String string;
        protected int position = 0;

        protected ValueParser(String string) {
            this.string = string;
        }

        protected void skipSpace() {
            while (this.position < this.string.length() && Character.isWhitespace(this.string.charAt(this.position))) {
                ++this.position;
            }
        }

        protected void consume(char character) {
            this.skipSpace();
            if (this.position >= this.string.length()) {
                throw new IllegalArgumentException("At value position " + this.position + ": Expected a '" + character + "' but got the end of the string");
            }
            if (this.string.charAt(this.position) != character) {
                throw new IllegalArgumentException("At value position " + this.position + ": Expected a '" + character + "' but got '" + this.string.charAt(this.position) + "'");
            }
            ++this.position;
        }

        protected String consumeIdentifier() {
            int endIdentifier = this.nextStopCharIndex(this.position, this.string);
            String identifier = this.string.substring(this.position, endIdentifier);
            this.position = endIdentifier;
            return identifier;
        }

        protected String consumeLabel() {
            if (this.consumeOptional('\'')) {
                int endQuote = this.string.indexOf(39, this.position);
                if (endQuote < 0) {
                    throw new IllegalArgumentException("At value position " + this.position + ": A label quoted by a tick (') must end by another tick");
                }
                String label = this.string.substring(this.position, endQuote);
                this.position = endQuote + 1;
                return label;
            }
            if (this.consumeOptional('\"')) {
                int endQuote = this.string.indexOf(34, this.position);
                if (endQuote < 0) {
                    throw new IllegalArgumentException("At value position " + this.position + ": A label quoted by a double quote (\") must end by another double quote");
                }
                String label = this.string.substring(this.position, endQuote);
                this.position = endQuote + 1;
                return label;
            }
            return this.consumeIdentifier();
        }

        /*
         * Exception decompiling
         */
        protected Number consumeNumber(TensorType.Value cellValueType) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected boolean consumeOptional(char character) {
            this.skipSpace();
            if (this.position >= this.string.length()) {
                return false;
            }
            if (this.string.charAt(this.position) != character) {
                return false;
            }
            ++this.position;
            return true;
        }

        protected int nextStopCharIndex(int position, String valueString) {
            while (position < valueString.length()) {
                if (Character.isWhitespace(valueString.charAt(position))) {
                    return position;
                }
                if (valueString.charAt(position) == ',') {
                    return position;
                }
                if (valueString.charAt(position) == ']') {
                    return position;
                }
                if (valueString.charAt(position) == '}') {
                    return position;
                }
                if (valueString.charAt(position) == ':') {
                    return position;
                }
                ++position;
            }
            throw new IllegalArgumentException("Malformed tensor string '" + valueString + "': Expected a ',', ']' or '}', ':' after position " + position);
        }
    }
}

