/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonDecoder;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import com.yahoo.slime.Type;
import com.yahoo.yolean.Exceptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SlimeUtils {
    public static void copyObject(Inspector from, Cursor to) {
        if (from.type() != Type.OBJECT) {
            throw new IllegalArgumentException("Cannot copy object: " + from);
        }
        from.traverse((name, inspector) -> SlimeUtils.setObjectEntry(inspector, name, to));
    }

    public static void setObjectEntry(Inspector from, String name, Cursor to) {
        switch (from.type()) {
            case NIX: {
                to.setNix(name);
                break;
            }
            case BOOL: {
                to.setBool(name, from.asBool());
                break;
            }
            case LONG: {
                to.setLong(name, from.asLong());
                break;
            }
            case DOUBLE: {
                to.setDouble(name, from.asDouble());
                break;
            }
            case STRING: {
                to.setString(name, from.asString());
                break;
            }
            case DATA: {
                to.setData(name, from.asData());
                break;
            }
            case ARRAY: {
                SlimeUtils.copyArray(from, to.setArray(name));
                break;
            }
            case OBJECT: {
                SlimeUtils.copyObject(from, to.setObject(name));
            }
        }
    }

    public static void copyArray(Inspector from, Cursor to) {
        if (from.type() != Type.ARRAY) {
            throw new IllegalArgumentException("Cannot copy array: " + from);
        }
        from.traverse((i, inspector) -> SlimeUtils.addValue(inspector, to));
    }

    private static void addValue(Inspector from, Cursor to) {
        switch (from.type()) {
            case NIX: {
                to.addNix();
                break;
            }
            case BOOL: {
                to.addBool(from.asBool());
                break;
            }
            case LONG: {
                to.addLong(from.asLong());
                break;
            }
            case DOUBLE: {
                to.addDouble(from.asDouble());
                break;
            }
            case STRING: {
                to.addString(from.asString());
                break;
            }
            case DATA: {
                to.addData(from.asData());
                break;
            }
            case ARRAY: {
                SlimeUtils.copyArray(from, to.addArray());
                break;
            }
            case OBJECT: {
                SlimeUtils.copyObject(from, to.addObject());
            }
        }
    }

    public static byte[] toJsonBytes(Slime slime) throws IOException {
        return SlimeUtils.toJsonBytes(slime.get());
    }

    public static byte[] toJsonBytes(Inspector inspector) throws IOException {
        return SlimeUtils.toJsonBytes(inspector, true);
    }

    public static byte[] toJsonBytes(Inspector inspector, boolean compact) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new JsonFormat(compact ? 0 : 2).encode((OutputStream)baos, inspector);
        return baos.toByteArray();
    }

    public static String toJson(Slime slime) {
        return SlimeUtils.toJson(slime.get());
    }

    public static String toJson(Inspector inspector) {
        return SlimeUtils.toJson(inspector, true);
    }

    public static String toJson(Inspector inspector, boolean compact) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JsonFormat jsonFormat = new JsonFormat(compact ? 0 : 2);
        Exceptions.uncheck(() -> jsonFormat.encode((OutputStream)outputStream, inspector));
        return outputStream.toString(StandardCharsets.UTF_8);
    }

    public static Slime jsonToSlime(byte[] json) {
        Slime slime = new Slime();
        new JsonDecoder().decode(slime, json);
        return slime;
    }

    public static Slime jsonToSlime(String json) {
        return SlimeUtils.jsonToSlime(json.getBytes(StandardCharsets.UTF_8));
    }

    public static Slime jsonToSlimeOrThrow(String json) {
        return SlimeUtils.jsonToSlimeOrThrow(json.getBytes(StandardCharsets.UTF_8));
    }

    public static Slime jsonToSlimeOrThrow(byte[] json) {
        Slime slime = new Slime();
        new JsonDecoder().decodeOrThrow(slime, json);
        return slime;
    }

    public static Instant instant(Inspector field) {
        return Instant.ofEpochMilli(field.asLong());
    }

    public static Duration duration(Inspector field) {
        return Duration.ofMillis(field.asLong());
    }

    public static Optional<String> optionalString(Inspector inspector) {
        return Optional.of(inspector.asString()).filter(s -> !s.isEmpty());
    }

    public static OptionalLong optionalLong(Inspector field) {
        return field.valid() ? OptionalLong.of(field.asLong()) : OptionalLong.empty();
    }

    public static OptionalInt optionalInteger(Inspector field) {
        return field.valid() ? OptionalInt.of((int)field.asLong()) : OptionalInt.empty();
    }

    public static OptionalDouble optionalDouble(Inspector field) {
        return field.valid() ? OptionalDouble.of(field.asDouble()) : OptionalDouble.empty();
    }

    public static Optional<Instant> optionalInstant(Inspector field) {
        return SlimeUtils.optionalLong(field).stream().mapToObj(Instant::ofEpochMilli).findFirst();
    }

    public static Optional<Duration> optionalDuration(Inspector field) {
        return SlimeUtils.optionalLong(field).stream().mapToObj(Duration::ofMillis).findFirst();
    }

    public static Iterator<Inspector> entriesIterator(final Inspector inspector) {
        return new Iterator<Inspector>(){
            private int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < inspector.entries();
            }

            @Override
            public Inspector next() {
                return inspector.entry(this.current++);
            }
        };
    }

    public static Stream<Inspector> entriesStream(Inspector inspector) {
        int characteristics = 336;
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(SlimeUtils.entriesIterator(inspector), characteristics), false);
    }
}

