/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.TypeResolver;
import com.yahoo.tensor.evaluation.EvaluationContext;
import com.yahoo.tensor.evaluation.Name;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Rename<NAMETYPE extends Name>
extends PrimitiveTensorFunction<NAMETYPE> {
    private final TensorFunction<NAMETYPE> argument;
    private final List<String> fromDimensions;
    private final List<String> toDimensions;
    private final Map<String, String> fromToMap;

    public Rename(TensorFunction<NAMETYPE> argument, String fromDimension, String toDimension) {
        this(argument, List.of(fromDimension), List.of(toDimension));
    }

    public Rename(TensorFunction<NAMETYPE> argument, List<String> fromDimensions, List<String> toDimensions) {
        Objects.requireNonNull(argument, "The argument tensor cannot be null");
        Objects.requireNonNull(fromDimensions, "The 'from' dimensions cannot be null");
        Objects.requireNonNull(toDimensions, "The 'to' dimensions cannot be null");
        if (fromDimensions.isEmpty()) {
            throw new IllegalArgumentException("from dimensions is empty, must rename at least one dimension");
        }
        if (fromDimensions.size() != toDimensions.size()) {
            throw new IllegalArgumentException("Rename from and to dimensions must be equal, was " + fromDimensions.size() + " and " + toDimensions.size());
        }
        this.argument = argument;
        this.fromDimensions = List.copyOf(fromDimensions);
        this.toDimensions = List.copyOf(toDimensions);
        this.fromToMap = Rename.fromToMap(fromDimensions, toDimensions);
    }

    public List<String> fromDimensions() {
        return this.fromDimensions;
    }

    public List<String> toDimensions() {
        return this.toDimensions;
    }

    private static Map<String, String> fromToMap(List<String> fromDimensions, List<String> toDimensions) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < fromDimensions.size(); ++i) {
            map.put(fromDimensions.get(i), toDimensions.get(i));
        }
        return map;
    }

    @Override
    public List<TensorFunction<NAMETYPE>> arguments() {
        return List.of(this.argument);
    }

    @Override
    public TensorFunction<NAMETYPE> withArguments(List<TensorFunction<NAMETYPE>> arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Rename must have 1 argument, got " + arguments.size());
        }
        return new Rename<NAMETYPE>(arguments.get(0), this.fromDimensions, this.toDimensions);
    }

    @Override
    public PrimitiveTensorFunction<NAMETYPE> toPrimitive() {
        return this;
    }

    @Override
    public TensorType type(TypeContext<NAMETYPE> context) {
        List<String> resolvedFromDimensions = this.fromDimensions.stream().map(d -> context.resolveBinding((String)d)).toList();
        List<String> resolvedToDimensions = this.toDimensions.stream().map(d -> context.resolveBinding((String)d)).toList();
        return TypeResolver.rename(this.argument.type(context), resolvedFromDimensions, resolvedToDimensions);
    }

    @Override
    public Tensor evaluate(EvaluationContext<NAMETYPE> context) {
        Tensor tensor = this.argument.evaluate(context);
        TensorType renamedType = TypeResolver.rename(tensor.type(), this.fromDimensions, this.toDimensions);
        int[] toIndexes = new int[tensor.type().dimensions().size()];
        int i = 0;
        while (i < tensor.type().dimensions().size()) {
            String dimensionName = tensor.type().dimensions().get(i).name();
            String newDimensionName = this.fromToMap.getOrDefault(dimensionName, dimensionName);
            toIndexes[renamedType.indexOfDimension((String)newDimensionName).get().intValue()] = i++;
        }
        if (this.simpleRenameIsPossible(toIndexes)) {
            return tensor.withType(renamedType);
        }
        Tensor.Builder builder = Tensor.Builder.of(renamedType);
        Iterator<Tensor.Cell> i2 = tensor.cellIterator();
        while (i2.hasNext()) {
            Map.Entry cell = i2.next();
            TensorAddress renamedAddress = ((TensorAddress)cell.getKey()).partialCopy(toIndexes);
            builder.cell(renamedAddress, (double)((Double)cell.getValue()));
        }
        return builder.build();
    }

    private boolean simpleRenameIsPossible(int[] toIndexes) {
        for (int i = 0; i < toIndexes.length; ++i) {
            if (toIndexes[i] == i) continue;
            return false;
        }
        return true;
    }

    private String toVectorString(List<String> elements, ToStringContext<NAMETYPE> context) {
        if (elements.size() == 1) {
            return context.resolveBinding(elements.get(0));
        }
        StringBuilder b = new StringBuilder("(");
        for (String element : elements) {
            b.append(context.resolveBinding(element)).append(", ");
        }
        b.setLength(b.length() - 2);
        b.append(")");
        return b.toString();
    }

    @Override
    public String toString(ToStringContext<NAMETYPE> context) {
        return "rename(" + this.argument.toString(context) + ", " + this.toVectorString(this.fromDimensions, context) + ", " + this.toVectorString(this.toDimensions, context) + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash("rename", this.argument, this.fromDimensions, this.toDimensions);
    }
}

