/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.google.common.collect.ImmutableList;
import com.yahoo.tensor.evaluation.Name;
import com.yahoo.tensor.functions.CompositeTensorFunction;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.List;
import java.util.Objects;

public class XwPlusB<NAMETYPE extends Name>
extends CompositeTensorFunction<NAMETYPE> {
    private final TensorFunction<NAMETYPE> x;
    private final TensorFunction<NAMETYPE> w;
    private final TensorFunction<NAMETYPE> b;
    private final String dimension;

    public XwPlusB(TensorFunction<NAMETYPE> x, TensorFunction<NAMETYPE> w, TensorFunction<NAMETYPE> b, String dimension) {
        this.x = x;
        this.w = w;
        this.b = b;
        this.dimension = dimension;
    }

    @Override
    public List<TensorFunction<NAMETYPE>> arguments() {
        return ImmutableList.of(this.x, this.w, this.b);
    }

    @Override
    public TensorFunction<NAMETYPE> withArguments(List<TensorFunction<NAMETYPE>> arguments) {
        if (arguments.size() != 3) {
            throw new IllegalArgumentException("XwPlusB must have 3 arguments, got " + arguments.size());
        }
        return new XwPlusB<NAMETYPE>(arguments.get(0), arguments.get(1), arguments.get(2), this.dimension);
    }

    @Override
    public PrimitiveTensorFunction<NAMETYPE> toPrimitive() {
        PrimitiveTensorFunction<NAMETYPE> primitiveX = this.x.toPrimitive();
        PrimitiveTensorFunction<NAMETYPE> primitiveW = this.w.toPrimitive();
        PrimitiveTensorFunction<NAMETYPE> primitiveB = this.b.toPrimitive();
        return new Join<NAMETYPE>(new Reduce<NAMETYPE>(new Join<NAMETYPE>(primitiveX, primitiveW, ScalarFunctions.multiply()), Reduce.Aggregator.sum, this.dimension), primitiveB, ScalarFunctions.add());
    }

    @Override
    public String toString(ToStringContext<NAMETYPE> context) {
        return "xw_plus_b(" + this.x.toString(context) + ", " + this.w.toString(context) + ", " + this.b.toString(context) + ", " + this.dimension + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash("xwplusb", this.x, this.w, this.b, this.dimension);
    }
}

