/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.google.common.collect.ImmutableList;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.Name;
import com.yahoo.tensor.functions.CompositeTensorFunction;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.List;
import java.util.Objects;

public class Matmul<NAMETYPE extends Name>
extends CompositeTensorFunction<NAMETYPE> {
    private final TensorFunction<NAMETYPE> argument1;
    private final TensorFunction<NAMETYPE> argument2;
    private final String dimension;

    public Matmul(TensorFunction<NAMETYPE> argument1, TensorFunction<NAMETYPE> argument2, String dimension) {
        this.argument1 = argument1;
        this.argument2 = argument2;
        this.dimension = dimension;
    }

    public static TensorType outputType(TensorType a, TensorType b, String dimension) {
        return Join.outputType(a, b);
    }

    @Override
    public List<TensorFunction<NAMETYPE>> arguments() {
        return ImmutableList.of(this.argument1, this.argument2);
    }

    @Override
    public TensorFunction<NAMETYPE> withArguments(List<TensorFunction<NAMETYPE>> arguments) {
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Matmul must have 2 arguments, got " + arguments.size());
        }
        return new Matmul<NAMETYPE>(arguments.get(0), arguments.get(1), this.dimension);
    }

    @Override
    public PrimitiveTensorFunction<NAMETYPE> toPrimitive() {
        PrimitiveTensorFunction<NAMETYPE> primitiveArgument1 = this.argument1.toPrimitive();
        PrimitiveTensorFunction<NAMETYPE> primitiveArgument2 = this.argument2.toPrimitive();
        return new Reduce<NAMETYPE>(new Join<NAMETYPE>(primitiveArgument1, primitiveArgument2, ScalarFunctions.multiply()), Reduce.Aggregator.sum, this.dimension);
    }

    @Override
    public String toString(ToStringContext<NAMETYPE> context) {
        return "matmul(" + this.argument1.toString(context) + ", " + this.argument2.toString(context) + ", " + this.dimension + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash("matmul", this.argument1, this.argument2, this.dimension);
    }
}

