/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class GrowableBufferOutputStream
extends OutputStream {
    private ByteBuffer lastBuffer;
    private final ByteBuffer directBuffer;
    private final LinkedList<ByteBuffer> bufferList = new LinkedList();
    private final Stack<ByteBuffer> recycledBuffers = new Stack();
    private final int bufferSize;
    private final int maxBuffers;

    public GrowableBufferOutputStream(int bufferSize, int maxBuffers) {
        this.bufferSize = bufferSize;
        this.maxBuffers = maxBuffers;
        this.lastBuffer = ByteBuffer.allocate(bufferSize);
        this.directBuffer = ByteBuffer.allocateDirect(bufferSize);
    }

    @Override
    public void write(byte[] cbuf, int off, int len) throws IOException {
        if (this.lastBuffer.remaining() >= len) {
            this.lastBuffer.put(cbuf, off, len);
            return;
        }
        int residue = len;
        while (residue > 0) {
            int newOffset = len - residue;
            int toWrite = Math.min(this.lastBuffer.remaining(), residue);
            this.lastBuffer.put(cbuf, newOffset, toWrite);
            if ((residue -= toWrite) == 0) continue;
            this.extend();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public String toString() {
        return "GrowableBufferOutputStream, writable size " + this.writableSize() + " bytes, " + this.numWritableBuffers() + " buffers, last buffer position " + this.lastBuffer.position() + ", last buffer limit " + this.lastBuffer.limit();
    }

    @Override
    public void write(int b) {
        if (this.lastBuffer.remaining() == 0) {
            this.extend();
        }
        this.lastBuffer.put((byte)b);
    }

    @Override
    public void flush() {
        if (this.lastBuffer.position() > 0) {
            this.extend();
        }
    }

    @Override
    public void close() {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int channelWrite(WritableByteChannel channel) throws IOException {
        int totalWritten = 0;
        while (!this.bufferList.isEmpty()) {
            ByteBuffer buffer = this.bufferList.getFirst();
            int written = 0;
            ByteBuffer byteBuffer = this.directBuffer;
            synchronized (byteBuffer) {
                this.directBuffer.clear();
                this.directBuffer.put(buffer);
                this.directBuffer.flip();
                written = channel.write(this.directBuffer);
                int left = this.directBuffer.remaining();
                if (left > 0) {
                    int oldpos = buffer.position();
                    buffer.position(oldpos - left);
                }
                totalWritten += written;
            }
            if (buffer.remaining() == 0) {
                this.bufferList.removeFirst();
                this.recycleBuffer(buffer);
            }
            if (written != 0) continue;
            break;
        }
        return totalWritten;
    }

    public int numWritableBuffers() {
        return this.bufferList.size();
    }

    public void clear() {
        this.flush();
        this.bufferList.clear();
    }

    public void clearCache() {
        this.recycledBuffers.clear();
    }

    public void clearAll() {
        this.clear();
        this.clearCache();
    }

    public int writableSize() {
        Iterator it = this.bufferList.iterator();
        int size = 0;
        while (it.hasNext()) {
            size += ((ByteBuffer)it.next()).remaining();
        }
        return size;
    }

    public ByteBuffer[] getWritableBuffers() {
        this.flush();
        ByteBuffer[] result = new ByteBuffer[this.numWritableBuffers()];
        return this.bufferList.toArray(result);
    }

    private void extend() {
        this.enqueueBuffer(this.lastBuffer);
        if (this.recycledBuffers.empty()) {
            this.lastBuffer = ByteBuffer.allocate(this.bufferSize);
        } else {
            this.lastBuffer = this.recycledBuffers.pop();
            this.lastBuffer.clear();
        }
    }

    private void enqueueBuffer(ByteBuffer buffer) {
        buffer.flip();
        this.bufferList.addLast(buffer);
    }

    private void recycleBuffer(ByteBuffer buffer) {
        if (this.recycledBuffers.size() >= this.maxBuffers) {
            return;
        }
        this.recycledBuffers.push(buffer);
    }
}

