/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.Name;
import com.yahoo.tensor.functions.CompositeTensorFunction;
import com.yahoo.tensor.functions.Generate;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Random<NAMETYPE extends Name>
extends CompositeTensorFunction<NAMETYPE> {
    private final TensorType type;

    public Random(TensorType type) {
        this.type = type;
    }

    @Override
    public List<TensorFunction<NAMETYPE>> arguments() {
        return List.of();
    }

    @Override
    public TensorFunction<NAMETYPE> withArguments(List<TensorFunction<NAMETYPE>> arguments) {
        if (arguments.size() != 0) {
            throw new IllegalArgumentException("Random must have 0 arguments, got " + arguments.size());
        }
        return this;
    }

    @Override
    public PrimitiveTensorFunction<NAMETYPE> toPrimitive() {
        return new Generate(this.type, ScalarFunctions.random());
    }

    @Override
    public String toString(ToStringContext<NAMETYPE> context) {
        return "random(" + this.dimensionNames().collect(Collectors.joining(",")) + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash("random", this.type);
    }

    private Stream<String> dimensionNames() {
        return this.type.dimensions().stream().map(TensorType.Dimension::toString);
    }
}

