/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.io;

import com.yahoo.io.AbstractByteWriter;
import com.yahoo.text.Utf8;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Utf8ByteWriter
extends AbstractByteWriter {
    private ByteBuffer myBuf;

    public Utf8ByteWriter(int initialBuffer) {
        super(Utf8.getNewEncoder());
        this.myBuf = ByteBuffer.allocate(initialBuffer);
    }

    @Override
    public void send(ByteBuffer src) throws IOException {
        if (this.myBuf.remaining() < src.remaining()) {
            ByteBuffer newBuf = ByteBuffer.allocate(Integer.highestOneBit(this.myBuf.position() + src.remaining()) << 1);
            this.myBuf.flip();
            newBuf.put(this.myBuf);
            this.myBuf = newBuf;
        }
        this.myBuf.put(src);
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }

    @Override
    public void close() throws IOException {
        this.buffer.flush();
        this.myBuf.flip();
    }

    public ByteBuffer getBuf() {
        if (this.myBuf.position() != 0) {
            throw new IllegalStateException("Call close() befor getBuf(), pos=" + this.myBuf.position() + ", limit=" + this.myBuf.limit());
        }
        return this.myBuf;
    }
}

