/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.net;

import ai.vespa.net.InetAddressUtil;
import com.google.common.net.InetAddresses;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class CidrBlock {
    private final BigInteger addressInteger;
    private final int prefixLength;
    private final int addressLength;

    public CidrBlock(InetAddress inetAddress) {
        this(inetAddress, 8 * inetAddress.getAddress().length);
    }

    public CidrBlock(InetAddress inetAddress, int prefixLength) {
        this(inetAddress.getAddress(), prefixLength);
    }

    public CidrBlock(byte[] address, int prefixLength) {
        if (prefixLength < 0) {
            throw new IllegalArgumentException("Prefix size cannot be negative, but was " + prefixLength);
        }
        this.prefixLength = prefixLength;
        this.addressLength = 8 * address.length;
        if (prefixLength > this.addressLength) {
            throw new IllegalArgumentException(String.format("Prefix size (%s) cannot be longer than address length (%s)", prefixLength, this.addressLength));
        }
        this.addressInteger = CidrBlock.inetAddressToBigInteger(address);
    }

    private CidrBlock(BigInteger addressInteger, int prefixLength, int addressLength) {
        this.addressInteger = addressInteger;
        this.prefixLength = prefixLength;
        this.addressLength = addressLength;
    }

    public InetAddress getInetAddress() {
        return CidrBlock.bitsToInetAddress(this.addressInteger, this.addressLength);
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    private int suffixLength() {
        return this.addressLength - this.prefixLength;
    }

    public boolean isIpv6() {
        return this.addressLength == 128;
    }

    public boolean contains(InetAddress address) {
        BigInteger addressInteger = new CidrBlock((InetAddress)address).addressInteger;
        return this.firstAddressInteger().compareTo(addressInteger) <= 0 && addressInteger.compareTo(this.lastAddressInteger()) <= 0;
    }

    private BigInteger firstAddressInteger() {
        return this.addressInteger.shiftRight(this.suffixLength()).shiftLeft(this.suffixLength());
    }

    private BigInteger lastAddressInteger() {
        return this.addressInteger.or(this.suffixMask());
    }

    private BigInteger suffixMask() {
        return BigInteger.ONE.shiftLeft(this.suffixLength()).subtract(BigInteger.ONE);
    }

    public CidrBlock resize(int newPrefixLength) {
        return new CidrBlock(this.addressInteger, newPrefixLength, this.addressLength);
    }

    public CidrBlock clearLeastSignificantBits(int bits) {
        return new CidrBlock(this.firstAddressInteger(), this.prefixLength, this.addressLength);
    }

    public CidrBlock clearHostIdentifier() {
        return this.clearLeastSignificantBits(this.suffixLength());
    }

    public int getByte(int byteOffset) {
        return this.addressInteger.shiftRight(this.addressLength - 8 * (byteOffset + 1)).and(BigInteger.valueOf(255L)).intValueExact();
    }

    public CidrBlock setByte(int byteOffset, int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Byte value must be between 0 and 255, but was " + n);
        }
        int byteDiff = n - this.getByte(byteOffset);
        return this.addByteRaw(byteOffset, byteDiff);
    }

    public CidrBlock addByte(int byteOffset, int n) {
        int oldByte = this.getByte(byteOffset);
        int newByte = 0xFF & oldByte + n;
        return this.addByteRaw(byteOffset, newByte - oldByte);
    }

    private CidrBlock addByteRaw(int byteOffset, int n) {
        BigInteger bit = this.addressInteger.add(BigInteger.valueOf(n).shiftLeft(this.addressLength - 8 * (byteOffset + 1)));
        return new CidrBlock(bit, this.prefixLength, this.addressLength);
    }

    public boolean overlapsWith(CidrBlock other) {
        if (this.isIpv6() != other.isIpv6()) {
            return false;
        }
        int ignoreLastNBits = this.addressLength - Math.min(this.prefixLength(), other.prefixLength());
        return this.addressInteger.shiftRight(ignoreLastNBits).equals(other.addressInteger.shiftRight(ignoreLastNBits));
    }

    public String getDomainName() {
        int start;
        StringBuilder recordPtr = new StringBuilder(75);
        int segmentWidth = this.isIpv6() ? 4 : 8;
        for (int i = start = this.suffixLength() - (segmentWidth - this.prefixLength % segmentWidth) % segmentWidth; i < this.addressLength; i += segmentWidth) {
            int segment = this.addressInteger.shiftRight(i).and(BigInteger.ONE.shiftLeft(segmentWidth).subtract(BigInteger.ONE)).intValueExact();
            recordPtr.append(this.isIpv6() ? Integer.toHexString(segment) : Integer.valueOf(segment)).append(".");
        }
        return recordPtr.append(this.isIpv6() ? "ip6" : "in-addr").append(".arpa.").toString();
    }

    public Iterable<CidrBlock> iterableCidrs() {
        return () -> new Iterator<CidrBlock>(){
            private final BigInteger increment;
            private final BigInteger maxValue;
            private BigInteger current;
            {
                this.increment = BigInteger.ONE.shiftLeft(CidrBlock.this.suffixLength());
                this.maxValue = BigInteger.ONE.shiftLeft(CidrBlock.this.addressLength).subtract(this.increment);
                this.current = CidrBlock.this.addressInteger;
            }

            @Override
            public boolean hasNext() {
                return this.current.compareTo(this.maxValue) < 0;
            }

            @Override
            public CidrBlock next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                CidrBlock cidrBlock = new CidrBlock(this.current, CidrBlock.this.prefixLength, CidrBlock.this.addressLength);
                this.current = this.current.add(this.increment);
                return cidrBlock;
            }
        };
    }

    public Iterable<InetAddress> iterableIps() {
        return () -> new Iterator<InetAddress>(){
            private final BigInteger maxValue;
            private BigInteger current;
            {
                this.maxValue = CidrBlock.this.lastAddressInteger();
                this.current = CidrBlock.this.addressInteger;
            }

            @Override
            public boolean hasNext() {
                return this.current.compareTo(this.maxValue) <= 0;
            }

            @Override
            public InetAddress next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                InetAddress inetAddress = CidrBlock.bitsToInetAddress(this.current, CidrBlock.this.addressLength);
                this.current = this.current.add(BigInteger.ONE);
                return inetAddress;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CidrBlock cidrBlock = (CidrBlock)o;
        return this.prefixLength == cidrBlock.prefixLength && Objects.equals(this.addressInteger, cidrBlock.addressInteger);
    }

    public int hashCode() {
        return Objects.hash(this.addressInteger, this.prefixLength);
    }

    public String toString() {
        return this.asString();
    }

    public String asString() {
        return InetAddressUtil.toString(this.getInetAddress()) + "/" + this.prefixLength;
    }

    public static CidrBlock fromString(String cidr) {
        String[] cidrParts = cidr.split("/");
        if (cidrParts.length != 2) {
            throw new IllegalArgumentException("Invalid CIDR block, expected format to be '<ip address>/<prefix size>', but was '" + cidr + "'");
        }
        InetAddress inetAddress = InetAddresses.forString((String)cidrParts[0]);
        int prefixSize = Integer.parseInt(cidrParts[1]);
        return new CidrBlock(inetAddress, prefixSize);
    }

    private static BigInteger inetAddressToBigInteger(byte[] address) {
        BigInteger bit = BigInteger.ZERO;
        for (byte b : address) {
            bit = bit.shiftLeft(8).add(BigInteger.valueOf(b & 0xFF));
        }
        return bit;
    }

    private static InetAddress bitsToInetAddress(BigInteger ipAddressBits, int addressLength) {
        try {
            byte[] addr = ipAddressBits.toByteArray();
            int addressBytes = addressLength / 8;
            if (addr.length != addressBytes) {
                byte[] temp = new byte[addressBytes];
                System.arraycopy(addr, Math.max(addr.length - addressBytes, 0), temp, Math.max(addressBytes - addr.length, 0), Math.min(addr.length, addressBytes));
                addr = temp;
            }
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            throw new UncheckedIOException(e);
        }
    }
}

